/*
 * Decompiled with CFR 0.152.
 */
package clsvis;

import clsvis.model.ElementKind;
import java.awt.Color;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public abstract class Utils {
    private static final Map<ElementKind, Color> backgroundColorMapMutable = new EnumMap<ElementKind, Color>(ElementKind.class);
    public static final Map<ElementKind, Color> backgroundColorMap = Collections.unmodifiableMap(backgroundColorMapMutable);

    public static String rootCauseAsString(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable.toString();
    }

    public static Class getClassType(Class clazz) {
        if (clazz == null) {
            return null;
        }
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (clazz.isAnonymousClass() || clazz.isPrimitive()) {
            return null;
        }
        return clazz;
    }

    public static String colorAsRRGGBB(String colorHex) {
        while (colorHex.length() < 6) {
            colorHex = "0" + colorHex;
        }
        return colorHex;
    }

    static {
        for (ElementKind ek : ElementKind.values()) {
            backgroundColorMapMutable.put(ek, new Color(ek.colorNum));
        }
    }
}

