/*
 * Decompiled with CFR 0.152.
 */
package clsvis.gui;

import clsvis.gui.ClassVisualizerView;
import java.awt.Window;
import java.io.File;
import java.util.logging.LogManager;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskService;

public class ClassVisualizer
extends SingleFrameApplication {
    private static String[] projectsToImport;
    private ClassVisualizerView classVisualizerView;

    @Override
    protected void startup() {
        this.classVisualizerView = new ClassVisualizerView(this);
        this.show(this.classVisualizerView);
    }

    @Override
    protected void configureWindow(Window root) {
    }

    @Override
    protected void ready() {
        ClassVisualizerView.logger.info("Application started");
        File[] projectPaths = new File[projectsToImport.length];
        for (int i = 0; i < projectsToImport.length; ++i) {
            projectPaths[i] = new File(projectsToImport[i]);
        }
        ClassVisualizer application = ClassVisualizer.getApplication();
        TaskService taskService = application.getContext().getTaskService();
        if (projectPaths.length > 0) {
            taskService.execute(this.classVisualizerView.createImportProjectTask(projectPaths));
        }
    }

    public static ClassVisualizer getApplication() {
        return Application.getInstance(ClassVisualizer.class);
    }

    public static void main(String[] args) {
        if (System.getProperty("java.util.logging.config.file") == null) {
            try {
                LogManager.getLogManager().readConfiguration(ClassVisualizer.class.getResourceAsStream("/resources/logging.properties"));
            }
            catch (Exception ex) {
                System.err.println("LogManager configuration failed: " + ex);
            }
        }
        ClassVisualizerView.logger.info("Starting application...");
        projectsToImport = args;
        ClassVisualizer.launch(ClassVisualizer.class, args);
    }
}

