/*
 * Decompiled with CFR 0.152.
 */
package clsvis.gui;

import clsvis.Utils;
import clsvis.gui.ClassPresentationWrapper;
import clsvis.gui.ClassVisualizer;
import clsvis.gui.ClassVisualizerAboutBox;
import clsvis.gui.StructureBuilder;
import clsvis.gui.graph.GraphComponent;
import clsvis.logging.GUIHandler;
import clsvis.model.Class_;
import clsvis.model.ElementModifier;
import clsvis.model.RelationDirection;
import clsvis.model.RelationType;
import clsvis.process.importer.BaseProjectImporter;
import clsvis.process.importer.CompiledClassImporter;
import clsvis.process.importer.ImportProgressListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;

public class ClassVisualizerView
extends FrameView {
    private static final Cursor WAIT_CURSOR = new Cursor(3);
    private static final Color TREE_SELECTION_BG_COLOR = new Color(8900346);
    static final Logger logger = Logger.getLogger(ClassVisualizerView.class.getName());
    private JMenuItem addDirMenuItem;
    private JMenuItem addJarsMenuItem;
    private JMenu addMenu;
    private JPanel bottomPanel;
    private JTabbedPane centerTabbedPane;
    private JTable classesTable;
    private JTextField classesTableFilterTextField;
    private JPanel classesTablePanel;
    private JScrollPane classesTableScrollPane;
    private JTree classesTree;
    private JScrollPane classesTreeScrollPane;
    private JMenuItem collapseSubtreeMenuItem;
    private JScrollPane consoleScrollPane;
    private JTextArea consoleTextArea;
    private JLabel consoleTitle;
    private JMenuItem expandClassMenuItem;
    private JMenuItem expandSubtreeMenuItem;
    private JPopupMenu.Separator fileMenuSeparator;
    private JScrollPane graphScrollPane;
    private JScrollPane historyScrollPane;
    private JTable historyTable;
    private JMenuItem importDirMenuItem;
    private JMenuItem importJarMenuItem;
    private JMenu importMenu;
    private JSplitPane mainHorizontalSplitPane;
    private JPanel mainPanel;
    private JEditorPane membersEditorPane;
    private JPanel membersEditorPanel;
    private JScrollPane membersEditorScrollPane;
    private JLabel membersEditorSummaryLabel;
    private JTree membersTree;
    private JScrollPane membersTreeScrollPane;
    private JMenuBar menuBar;
    private JTabbedPane navigationTabbedPane;
    private JFileChooser openFileChooser;
    JProgressBar progressBar;
    private JTabbedPane rightTabbedPane;
    JLabel statusAnimationLabel;
    JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JSplitPane topLeftSplitPanel;
    private JSplitPane topRightSplitPane;
    private JPopupMenu treePopupMenu;
    private JPopupMenu.Separator treePopupMenuSeparator;
    final Timer messageTimer;
    final Timer busyIconTimer;
    final Icon idleIcon;
    final Icon[] busyIcons = new Icon[15];
    int busyIconIndex = 0;
    private JDialog aboutBox;
    private FileFilter jarFileFilter;
    private FileFilter classFileFilter;
    private GraphComponent graphComponent;
    BaseProjectImporter projectImporter;
    private Object currentClass_;
    private Object viewedClass_;
    private ClassesTableModel historyTableModel = new ClassesTableModel();
    private ClassesTableRowFilter classesTableRowFilter;

    public ClassVisualizerView(SingleFrameApplication app) {
        super(app);
        UIManager.put("nimbusSelectionBackground", TREE_SELECTION_BG_COLOR);
        UIManager.put("nimbusSelectedText", Color.BLACK);
        this.initComponents();
        this.postInit();
        ResourceMap resourceMap = Application.getInstance(ClassVisualizer.class).getContext().getResourceMap(ClassVisualizerView.class);
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassVisualizerView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassVisualizerView.this.busyIconIndex = (ClassVisualizerView.this.busyIconIndex + 1) % ClassVisualizerView.this.busyIcons.length;
                ClassVisualizerView.this.statusAnimationLabel.setIcon(ClassVisualizerView.this.busyIcons[ClassVisualizerView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!ClassVisualizerView.this.busyIconTimer.isRunning()) {
                        ClassVisualizerView.this.statusAnimationLabel.setIcon(ClassVisualizerView.this.busyIcons[0]);
                        ClassVisualizerView.this.busyIconIndex = 0;
                        ClassVisualizerView.this.busyIconTimer.start();
                    }
                    ClassVisualizerView.this.progressBar.setVisible(true);
                    ClassVisualizerView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    ClassVisualizerView.this.busyIconTimer.stop();
                    ClassVisualizerView.this.statusAnimationLabel.setIcon(ClassVisualizerView.this.idleIcon);
                    ClassVisualizerView.this.progressBar.setVisible(false);
                    ClassVisualizerView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    ClassVisualizerView.this.statusMessageLabel.setText(text == null ? "" : text);
                    ClassVisualizerView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    ClassVisualizerView.this.progressBar.setVisible(true);
                    ClassVisualizerView.this.progressBar.setIndeterminate(false);
                    ClassVisualizerView.this.progressBar.setValue(value);
                }
            }
        });
    }

    private void postInit() {
        GUIHandler.setTextArea(this.consoleTextArea);
        this.jarFileFilter = new FileNameExtensionFilter("Java Archive (.jar)", "jar");
        this.classFileFilter = new FileNameExtensionFilter("Java Class (.class)", "class");
        this.graphComponent = new GraphComponent();
        this.graphComponent.setToolTipText("");
        this.graphComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ClassVisualizerView.this.graphMouseClicked(evt);
            }
        });
        this.graphScrollPane.setViewportView(this.graphComponent);
        this.classesTable.getSelectionModel().addListSelectionListener(new ClassesTableSelectionListener(this.classesTable));
        this.historyTable.getSelectionModel().addListSelectionListener(new ClassesTableSelectionListener(this.historyTable));
        this.classesTable.addMouseListener(new ClassesTableMouseListener());
        this.historyTable.addMouseListener(new ClassesTableMouseListener());
        this.classesTable.setDefaultRenderer(String.class, new ClassesTableCellRenderer());
        this.historyTable.setDefaultRenderer(String.class, new ClassesTableCellRenderer());
        this.historyTable.setDefaultRenderer(Integer.class, new ClassesTableCellRenderer());
        this.classesTableRowFilter = new ClassesTableRowFilter();
        this.classesTableFilterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ClassVisualizerView.this.classesTableRowFilterUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ClassVisualizerView.this.classesTableRowFilterUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ClassVisualizerView.this.classesTableRowFilterUpdated();
            }
        });
        this.membersTree.addTreeSelectionListener(new CustomTreeSelectionListener());
        this.classesTree.addTreeSelectionListener(new CustomTreeSelectionListener());
        this.membersTree.addMouseListener(new CustomTreeMouseListener());
        this.classesTree.addMouseListener(new CustomTreeMouseListener());
        this.projectImporter = new BaseProjectImporter();
        CompiledClassImporter classImporter = this.projectImporter.getClassImporter();
        classImporter.importClass(AccessibleObject.class);
        this.showClasses(classImporter);
    }

    private void demo() {
        CompiledClassImporter classImporter = this.projectImporter.getClassImporter();
        classImporter.importClass(ResultSet.class);
        classImporter.importClass(Timestamp.class);
        classImporter.importClass(java.sql.Date.class);
        classImporter.importClass(Time.class);
        classImporter.importClass(Statement.class);
        classImporter.importClass(PreparedStatement.class);
        classImporter.importClass(Date.class);
        classImporter.importClass(Calendar.class);
        classImporter.importClass(GregorianCalendar.class);
        classImporter.importClass(Map.class);
        classImporter.importClass(Thread.class);
        classImporter.importClass(JTable.class);
        classImporter.importClass(TreePath.class);
        classImporter.importClass(DefaultMutableTreeNode.class);
        classImporter.importClass(DefaultTreeModel.class);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = ClassVisualizer.getApplication().getMainFrame();
            this.aboutBox = new ClassVisualizerAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        ClassVisualizer.getApplication().show(this.aboutBox);
    }

    @Action
    public Task showImportJarsFileChooser() {
        return 0 != this.showFileChooser(this.jarFileFilter, 0, true, "showImportJarsFileChooser.Action.shortDescription", "showImportJarsFileChooser.Action.approveText") ? null : this.createImportProjectTask(this.openFileChooser.getSelectedFiles());
    }

    @Action
    public Task showImportDirFileChooser() {
        return 0 != this.showFileChooser(this.classFileFilter, 1, false, "showImportDirFileChooser.Action.shortDescription", "showImportDirFileChooser.Action.approveText") ? null : this.createImportProjectTask(this.openFileChooser.getSelectedFile());
    }

    @Action
    public void showAddJarsFileChooser() {
        if (0 == this.showFileChooser(this.jarFileFilter, 0, true, "showAddJarsFileChooser.Action.shortDescription", "showAddJarsFileChooser.Action.approveText")) {
            this.addToClassPath(this.openFileChooser.getSelectedFiles());
        }
    }

    @Action
    public void showAddDirFileChooser() {
        if (0 == this.showFileChooser(this.classFileFilter, 1, false, "showAddDirFileChooser.Action.shortDescription", "showAddDirFileChooser.Action.approveText")) {
            this.addToClassPath(this.openFileChooser.getSelectedFile());
        }
    }

    private int showFileChooser(FileFilter fileFilter, int selectionMode, boolean multiSelectionEnabled, String titleKey, String approveKey) {
        ResourceMap resourceMap = Application.getInstance(ClassVisualizer.class).getContext().getResourceMap(ClassVisualizerView.class);
        this.openFileChooser.setDialogTitle(resourceMap.getString(titleKey, new Object[0]));
        this.openFileChooser.setApproveButtonText(resourceMap.getString(approveKey, new Object[0]));
        this.openFileChooser.resetChoosableFileFilters();
        this.openFileChooser.setFileFilter(fileFilter);
        this.openFileChooser.setFileSelectionMode(selectionMode);
        this.openFileChooser.setMultiSelectionEnabled(multiSelectionEnabled);
        this.openFileChooser.setSelectedFile(null);
        this.openFileChooser.setSelectedFiles(null);
        return this.openFileChooser.showOpenDialog(ClassVisualizer.getApplication().getMainFrame());
    }

    Task createImportProjectTask(File ... paths) {
        return new ImportProjectTask(this.getApplication(), paths);
    }

    private void addToClassPath(File ... paths) {
        Level logLevel;
        String msg;
        Collection<File> classPaths = this.projectImporter.getClassPaths();
        int classPathsCountBefore = classPaths.size();
        this.projectImporter.addClassPaths(paths);
        int classPathsCountAfter = classPaths.size();
        int delta = classPathsCountAfter - classPathsCountBefore;
        if (delta > 0) {
            msg = String.format("%d element(s) added to class path; total count: %d", delta, classPathsCountAfter);
            logLevel = Level.INFO;
        } else {
            msg = "No elements added to class path";
            logLevel = Level.WARNING;
        }
        this.statusMessageLabel.setText(msg);
        this.messageTimer.restart();
        logger.log(logLevel, msg);
    }

    void showClasses(CompiledClassImporter classImporter) {
        this.getComponent().setCursor(WAIT_CURSOR);
        long time0 = System.currentTimeMillis();
        this.classesTable.setModel(new ClassesTableModel(classImporter.getImportedClasses()));
        long time1 = System.currentTimeMillis();
        ClassPresentationWrapper buildClassesTreeNode = StructureBuilder.buildClassesTreeNode2(classImporter.getImportedClassesRoot(), null);
        long time2 = System.currentTimeMillis();
        this.reloadTree(buildClassesTreeNode, this.classesTree);
        long time3 = System.currentTimeMillis();
        this.currentClass_ = null;
        this.viewedClass_ = null;
        this.selectClassAction(classImporter.getImportedSimpleClass());
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format("time stats: classesTable.setModel=%d, StructureBuilder.buildClassesTreeNode=%d, reloadTree=%d", time1 - time0, time2 - time1, time3 - time2));
        }
        this.getComponent().setCursor(null);
    }

    void selectClassAction(Object selectedObject) {
        if (selectedObject == null || !(selectedObject instanceof Class_) || this.currentClass_ == selectedObject) {
            return;
        }
        this.currentClass_ = selectedObject;
        Class_ class_ = (Class_)selectedObject;
        if (!AccessibleObject.class.getName().equals(class_.id) && this.historyTableModel.addRow(class_)) {
            this.historyTableModel.fireTableDataChanged();
        }
        this.graphComponent.setPreferredSize(this.graphScrollPane.getViewport().getSize());
        this.graphComponent.setMainClass(class_);
        this.reloadTree(StructureBuilder.buildMembersTreeNode(class_), this.membersTree);
        this.membersTree.expandRow(this.membersTree.getRowCount() - 1);
        this.membersTree.expandRow(1);
        this.viewClassAction(class_);
    }

    void viewClassAction(Object selectedObject) {
        if (selectedObject == null || !(selectedObject instanceof Class_) || this.viewedClass_ == selectedObject) {
            return;
        }
        this.viewedClass_ = selectedObject;
        Class_ class_ = (Class_)selectedObject;
        this.membersEditorPane.setText(StructureBuilder.buildClassUMLTable(class_));
        this.membersEditorPane.setCaretPosition(0);
    }

    private void reloadTree(TreeNode rootNode, JTree tree) {
        tree.setModel(new DefaultTreeModel(rootNode));
    }

    void treeMousePressedOrReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.treePopupMenu.show((JTree)evt.getSource(), evt.getX(), evt.getY());
        }
    }

    void tableMouseClicked(MouseEvent evt, JTable table) {
        int rowIdx = ((JTable)evt.getSource()).rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (rowIdx > -1) {
            ClassesTableModel model = (ClassesTableModel)table.getModel();
            Class_ clickedObject = model.getRow(table.convertRowIndexToModel(rowIdx));
            int clickCount = evt.getClickCount();
            if (clickCount == 2) {
                this.selectClassAction(clickedObject);
            }
        }
    }

    void classesTableRowFilterUpdated() {
        this.classesTableRowFilter.filter = this.classesTableFilterTextField.getText();
        ((TableRowSorter)this.classesTable.getRowSorter()).setRowFilter(this.classesTableRowFilter);
    }

    void graphMouseClicked(MouseEvent evt) {
        int clickCount = evt.getClickCount();
        Class_ clickedObject = this.graphComponent.selectVertexAt(evt.getX(), evt.getY());
        if (clickCount == 2) {
            this.selectClassAction(clickedObject);
        } else if (clickCount == 1) {
            this.viewClassAction(clickedObject);
        }
    }

    @Action
    public void expandSubtree() {
        this.processSubtree(TreeAction.EXPAND);
    }

    @Action
    public void collapseSubtree() {
        this.processSubtree(TreeAction.COLLAPSE);
    }

    @Action
    public void expandClass() {
        this.processSubtree(TreeAction.EXPAND_CLASS);
    }

    private void processSubtree(TreeAction action) {
        JTree tree = (JTree)this.treePopupMenu.getInvoker();
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                if (action == TreeAction.EXPAND) {
                    this.expandSubtree(tree, selectionPath);
                    continue;
                }
                if (action == TreeAction.COLLAPSE) {
                    tree.collapsePath(selectionPath);
                    continue;
                }
                if (action == TreeAction.EXPAND_CLASS) {
                    this.expandRelatedClass(tree, selectionPath);
                    continue;
                }
                throw new IllegalStateException("Unhandled action: " + (Object)((Object)action));
            }
        }
    }

    private void expandSubtree(JTree tree, TreePath treePath) {
        tree.expandPath(treePath);
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        int count = treeNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.expandSubtree(tree, treePath.pathByAddingChild(treeNode.getChildAt(i)));
        }
    }

    private void expandRelatedClass(JTree tree, TreePath treePath) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object userObject = treeNode.getUserObject();
        if (treeNode.isLeaf() && userObject != null && userObject instanceof Class_) {
            DefaultMutableTreeNode newTreeNode = StructureBuilder.buildMembersTreeNode((Class_)userObject);
            while (newTreeNode.getChildCount() > 0) {
                treeNode.add((DefaultMutableTreeNode)newTreeNode.getChildAt(0));
            }
        }
        ((DefaultTreeModel)tree.getModel()).nodeChanged(treeNode);
        tree.expandPath(treePath);
        if (treeNode.getChildCount() > 0) {
            tree.expandPath(treePath.pathByAddingChild(treeNode.getFirstChild()));
            tree.expandPath(treePath.pathByAddingChild(treeNode.getLastChild()));
        }
    }

    void selectClassOnClassesTree(Object userObject) {
        ClassPresentationWrapper prevNode;
        Class_ class_ = (Class_)userObject;
        if (class_.modifiers.contains((Object)ElementModifier.Interface)) {
            return;
        }
        ArrayList<Class_> classPath = new ArrayList<Class_>();
        while (true) {
            classPath.add(class_);
            if (class_.relationsMap.get((Object)RelationDirection.Outbound).get((Object)RelationType.SuperClass).isEmpty()) break;
            class_ = class_.relationsMap.get((Object)RelationDirection.Outbound).get((Object)RelationType.SuperClass).iterator().next();
        }
        Collections.reverse(classPath);
        Object[] path = new ClassPresentationWrapper[classPath.size()];
        TreeModel treeModel = this.classesTree.getModel();
        path[0] = prevNode = (ClassPresentationWrapper)treeModel.getRoot();
        for (int i = 1; i < path.length; ++i) {
            ClassPresentationWrapper currNode = new ClassPresentationWrapper((Class_)classPath.get(i), null);
            currNode = (ClassPresentationWrapper)prevNode.getChildAt(prevNode.getIndex(currNode));
            path[i] = currNode;
            prevNode = currNode;
        }
        TreePath treePath = new TreePath(path);
        this.classesTree.setSelectionPath(treePath);
        this.classesTree.scrollPathToVisible(treePath);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.mainHorizontalSplitPane = new JSplitPane();
        this.topLeftSplitPanel = new JSplitPane();
        this.navigationTabbedPane = new JTabbedPane();
        this.classesTablePanel = new JPanel();
        this.classesTableFilterTextField = new JTextField();
        this.classesTableScrollPane = new JScrollPane();
        this.classesTable = new JTable();
        this.membersTreeScrollPane = new JScrollPane();
        this.membersTree = new JTree();
        this.classesTreeScrollPane = new JScrollPane();
        this.classesTree = new JTree();
        this.historyScrollPane = new JScrollPane();
        this.historyTable = new JTable();
        this.topRightSplitPane = new JSplitPane();
        this.centerTabbedPane = new JTabbedPane();
        this.graphScrollPane = new JScrollPane();
        this.rightTabbedPane = new JTabbedPane();
        this.membersEditorPanel = new JPanel();
        this.membersEditorScrollPane = new JScrollPane();
        this.membersEditorPane = new JEditorPane();
        this.membersEditorSummaryLabel = new JLabel();
        this.bottomPanel = new JPanel();
        this.consoleTitle = new JLabel();
        this.consoleScrollPane = new JScrollPane();
        this.consoleTextArea = new JTextArea();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.importMenu = new JMenu();
        this.importJarMenuItem = new JMenuItem();
        this.importDirMenuItem = new JMenuItem();
        this.addMenu = new JMenu();
        this.addJarsMenuItem = new JMenuItem();
        this.addDirMenuItem = new JMenuItem();
        this.fileMenuSeparator = new JPopupMenu.Separator();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.openFileChooser = new JFileChooser();
        this.treePopupMenu = new JPopupMenu();
        this.expandClassMenuItem = new JMenuItem();
        this.treePopupMenuSeparator = new JPopupMenu.Separator();
        this.expandSubtreeMenuItem = new JMenuItem();
        this.collapseSubtreeMenuItem = new JMenuItem();
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setLayout(new BorderLayout());
        this.mainHorizontalSplitPane.setOrientation(0);
        this.mainHorizontalSplitPane.setName("mainHorizontalSplitPane");
        this.mainHorizontalSplitPane.setOneTouchExpandable(true);
        this.topLeftSplitPanel.setDividerLocation(320);
        this.topLeftSplitPanel.setName("topLeftSplitPanel");
        this.topLeftSplitPanel.setOneTouchExpandable(true);
        this.navigationTabbedPane.setName("navigationTabbedPane");
        this.classesTablePanel.setName("classesTablePanel");
        this.classesTablePanel.setLayout(new BorderLayout());
        ResourceMap resourceMap = Application.getInstance(ClassVisualizer.class).getContext().getResourceMap(ClassVisualizerView.class);
        this.classesTableFilterTextField.setToolTipText(resourceMap.getString("classesTableFilterTextField.toolTipText", new Object[0]));
        this.classesTableFilterTextField.setName("classesTableFilterTextField");
        this.classesTablePanel.add((Component)this.classesTableFilterTextField, "First");
        this.classesTableScrollPane.setName("classesTableScrollPane");
        this.classesTable.setAutoCreateRowSorter(true);
        this.classesTable.setModel(new ClassesTableModel(Collections.EMPTY_LIST));
        this.classesTable.setCellSelectionEnabled(true);
        this.classesTable.setName("classesTable");
        this.classesTableScrollPane.setViewportView(this.classesTable);
        this.classesTablePanel.add((Component)this.classesTableScrollPane, "Center");
        this.navigationTabbedPane.addTab(resourceMap.getString("classesTablePanel.TabConstraints.tabTitle", new Object[0]), null, this.classesTablePanel, resourceMap.getString("classesTablePanel.TabConstraints.tabToolTip", new Object[0]));
        this.membersTreeScrollPane.setName("membersTreeScrollPane");
        this.membersTree.setCellRenderer(new CustomTreeCellRenderer());
        this.membersTree.setName("membersTree");
        this.membersTree.setToggleClickCount(0);
        this.membersTreeScrollPane.setViewportView(this.membersTree);
        this.navigationTabbedPane.addTab(resourceMap.getString("membersTreeScrollPane.TabConstraints.tabTitle", new Object[0]), null, this.membersTreeScrollPane, resourceMap.getString("membersTreeScrollPane.TabConstraints.tabToolTip", new Object[0]));
        this.classesTreeScrollPane.setName("classesTreeScrollPane");
        this.classesTree.setCellRenderer(new CustomTreeCellRenderer());
        this.classesTree.setName("classesTree");
        this.classesTree.setToggleClickCount(0);
        this.classesTreeScrollPane.setViewportView(this.classesTree);
        this.navigationTabbedPane.addTab(resourceMap.getString("classesTreeScrollPane.TabConstraints.tabTitle", new Object[0]), null, this.classesTreeScrollPane, resourceMap.getString("classesTreeScrollPane.TabConstraints.tabToolTip", new Object[0]));
        this.historyScrollPane.setName("historyScrollPane");
        this.historyTable.setAutoCreateRowSorter(true);
        this.historyTable.setModel(this.historyTableModel);
        this.historyTable.setCellSelectionEnabled(true);
        this.historyTable.setName("historyTable");
        this.historyScrollPane.setViewportView(this.historyTable);
        this.navigationTabbedPane.addTab(resourceMap.getString("historyScrollPane.TabConstraints.tabTitle", new Object[0]), null, this.historyScrollPane, resourceMap.getString("historyScrollPane.TabConstraints.tabToolTip", new Object[0]));
        this.topLeftSplitPanel.setLeftComponent(this.navigationTabbedPane);
        this.topRightSplitPane.setName("topRightSplitPane");
        this.topRightSplitPane.setOneTouchExpandable(true);
        this.centerTabbedPane.setName("centerTabbedPane");
        this.graphScrollPane.setName("graphScrollPane");
        this.centerTabbedPane.addTab(resourceMap.getString("graphScrollPane.TabConstraints.tabTitle", new Object[0]), null, this.graphScrollPane, resourceMap.getString("graphScrollPane.TabConstraints.tabToolTip", new Object[0]));
        this.topRightSplitPane.setLeftComponent(this.centerTabbedPane);
        this.rightTabbedPane.setName("rightTabbedPane");
        this.membersEditorPanel.setName("membersEditorPanel");
        this.membersEditorPanel.setLayout(new BorderLayout());
        this.membersEditorScrollPane.setName("membersEditorScrollPane");
        this.membersEditorPane.setContentType("text/html");
        this.membersEditorPane.setEditable(false);
        this.membersEditorPane.setDoubleBuffered(true);
        this.membersEditorPane.setName("membersEditorPane");
        this.membersEditorPane.setOpaque(false);
        this.membersEditorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ClassVisualizerView.this.membersEditorPaneMouseClicked(evt);
            }
        });
        this.membersEditorScrollPane.setViewportView(this.membersEditorPane);
        this.membersEditorPanel.add((Component)this.membersEditorScrollPane, "Center");
        this.membersEditorSummaryLabel.setFont(resourceMap.getFont("membersEditorSummaryLabel.font"));
        this.membersEditorSummaryLabel.setHorizontalAlignment(0);
        this.membersEditorSummaryLabel.setName("membersEditorSummaryLabel");
        this.membersEditorPanel.add((Component)this.membersEditorSummaryLabel, "Last");
        this.rightTabbedPane.addTab(resourceMap.getString("membersEditorPanel.TabConstraints.tabTitle", new Object[0]), null, this.membersEditorPanel, resourceMap.getString("membersEditorPanel.TabConstraints.tabToolTip", new Object[0]));
        this.topRightSplitPane.setRightComponent(this.rightTabbedPane);
        this.topLeftSplitPanel.setRightComponent(this.topRightSplitPane);
        this.mainHorizontalSplitPane.setTopComponent(this.topLeftSplitPanel);
        this.bottomPanel.setName("bottomPanel");
        this.bottomPanel.setLayout(new BorderLayout());
        this.consoleTitle.setText(resourceMap.getString("consoleTitle.text", new Object[0]));
        this.consoleTitle.setName("consoleTitle");
        this.bottomPanel.add((Component)this.consoleTitle, "First");
        this.consoleScrollPane.setName("consoleScrollPane");
        this.consoleTextArea.setEditable(false);
        this.consoleTextArea.setRows(5);
        this.consoleTextArea.setName("consoleTextArea");
        this.consoleScrollPane.setViewportView(this.consoleTextArea);
        this.bottomPanel.add((Component)this.consoleScrollPane, "Center");
        this.mainHorizontalSplitPane.setRightComponent(this.bottomPanel);
        this.mainPanel.add((Component)this.mainHorizontalSplitPane, "Center");
        this.menuBar.setName("menuBar");
        fileMenu.setMnemonic('F');
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        this.importMenu.setMnemonic('L');
        this.importMenu.setText(resourceMap.getString("importMenu.text", new Object[0]));
        this.importMenu.setToolTipText(resourceMap.getString("importMenu.toolTipText", new Object[0]));
        this.importMenu.setName("importMenu");
        ApplicationActionMap actionMap = Application.getInstance(ClassVisualizer.class).getContext().getActionMap(ClassVisualizerView.class, this);
        this.importJarMenuItem.setAction(actionMap.get("showImportJarsFileChooser"));
        this.importJarMenuItem.setText(resourceMap.getString("importJarMenuItem.text", new Object[0]));
        this.importJarMenuItem.setName("importJarMenuItem");
        this.importMenu.add(this.importJarMenuItem);
        this.importDirMenuItem.setAction(actionMap.get("showImportDirFileChooser"));
        this.importDirMenuItem.setText(resourceMap.getString("importDirMenuItem.text", new Object[0]));
        this.importDirMenuItem.setName("importDirMenuItem");
        this.importMenu.add(this.importDirMenuItem);
        fileMenu.add(this.importMenu);
        this.addMenu.setMnemonic('A');
        this.addMenu.setText(resourceMap.getString("addMenu.text", new Object[0]));
        this.addMenu.setToolTipText(resourceMap.getString("addMenu.toolTipText", new Object[0]));
        this.addMenu.setName("addMenu");
        this.addJarsMenuItem.setAction(actionMap.get("showAddJarsFileChooser"));
        this.addJarsMenuItem.setText(resourceMap.getString("addJarsMenuItem.text", new Object[0]));
        this.addJarsMenuItem.setName("addJarsMenuItem");
        this.addMenu.add(this.addJarsMenuItem);
        this.addDirMenuItem.setAction(actionMap.get("showAddDirFileChooser"));
        this.addDirMenuItem.setText(resourceMap.getString("addDirMenuItem.text", new Object[0]));
        this.addDirMenuItem.setName("addDirMenuItem");
        this.addMenu.add(this.addDirMenuItem);
        fileMenu.add(this.addMenu);
        this.fileMenuSeparator.setName("fileMenuSeparator");
        fileMenu.add(this.fileMenuSeparator);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setMnemonic('H');
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 555, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 371, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.openFileChooser.setAcceptAllFileFilterUsed(false);
        this.openFileChooser.setApproveButtonToolTipText(resourceMap.getString("openFileChooser.approveButtonToolTipText", new Object[0]));
        this.openFileChooser.setFileHidingEnabled(false);
        this.openFileChooser.setName("openFileChooser");
        this.treePopupMenu.setName("treePopupMenu");
        this.expandClassMenuItem.setAction(actionMap.get("expandClass"));
        this.expandClassMenuItem.setText(resourceMap.getString("expandClassMenuItem.text", new Object[0]));
        this.expandClassMenuItem.setName("expandClassMenuItem");
        this.treePopupMenu.add(this.expandClassMenuItem);
        this.treePopupMenuSeparator.setName("treePopupMenuSeparator");
        this.treePopupMenu.add(this.treePopupMenuSeparator);
        this.expandSubtreeMenuItem.setAction(actionMap.get("expandSubtree"));
        this.expandSubtreeMenuItem.setName("expandSubtreeMenuItem");
        this.treePopupMenu.add(this.expandSubtreeMenuItem);
        this.collapseSubtreeMenuItem.setAction(actionMap.get("collapseSubtree"));
        this.collapseSubtreeMenuItem.setName("collapseSubtreeMenuItem");
        this.treePopupMenu.add(this.collapseSubtreeMenuItem);
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void membersEditorPaneMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.selectClassOnClassesTree(this.viewedClass_);
        }
    }

    private class ImportProjectTask
    extends Task<CompiledClassImporter, Void>
    implements ImportProgressListener {
        private File[] files;
        private int startClassesCount;
        private int endClassesCount;
        private int failedClassesCount;

        public ImportProjectTask(Application application, File ... files) {
            super(application);
            this.files = files;
        }

        @Override
        protected CompiledClassImporter doInBackground() throws Exception {
            CompiledClassImporter classImporter = ClassVisualizerView.this.projectImporter.getClassImporter();
            classImporter.setImportProgressListener(this);
            String projectName = this.files.length > 1 ? this.files[0].getParent() : (this.files.length == 1 ? this.files[0].getAbsolutePath() : "");
            String msg = "Importing project: " + projectName;
            this.setMessage(msg);
            logger.info(msg);
            this.startClassesCount = classImporter.getImportedClasses().size();
            ClassVisualizerView.this.projectImporter.importProject(this.files);
            this.endClassesCount = classImporter.getImportedClasses().size();
            this.failedClassesCount = classImporter.getNotImportedClassesCount();
            return classImporter;
        }

        @Override
        protected void succeeded(CompiledClassImporter classImporter) {
            boolean nonEmptyProject;
            float time = this.getExecutionDuration(TimeUnit.MILLISECONDS);
            int classesCount = this.endClassesCount - this.startClassesCount;
            boolean bl = nonEmptyProject = !ClassVisualizerView.this.projectImporter.getClassNames().isEmpty();
            String msg = nonEmptyProject ? (this.failedClassesCount == 0 ? String.format("Project imported successfully: %d classes in %.3fs.", classesCount, Float.valueOf(time / 1000.0f)) : String.format("Project imported with some problems: %d classes in %.3fs (%d classes not imported).", classesCount, (double)time / 1000.0, this.failedClassesCount)) : "Empty project - no classes";
            this.setMessage(msg);
            logger.log(nonEmptyProject ? Level.INFO : Level.WARNING, msg + "\n");
            ClassVisualizerView.this.projectImporter.cleanupAfterImport();
            ClassVisualizerView.this.showClasses(classImporter);
        }

        @Override
        protected void failed(Throwable cause) {
            String msg = "Error during project import: " + Utils.rootCauseAsString(cause);
            this.setMessage(msg);
            logger.severe(msg + "\n");
            ClassVisualizerView.this.projectImporter.cleanupAfterImport();
        }

        @Override
        public void importProgress(int importedCount, int totalCount) {
            this.setProgress(importedCount, 0, totalCount);
        }
    }

    private class CustomTreeMouseListener
    extends MouseAdapter {
        private CustomTreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath treePath = ((JTree)e.getSource()).getPathForLocation(e.getX(), e.getY());
            if (treePath != null) {
                TreeNode clickedNode = (TreeNode)treePath.getLastPathComponent();
                Object userObject = clickedNode instanceof ClassPresentationWrapper ? ((ClassPresentationWrapper)clickedNode).class_ : ((DefaultMutableTreeNode)clickedNode).getUserObject();
                int clickCount = e.getClickCount();
                if (clickCount == 2) {
                    ClassVisualizerView.this.selectClassAction(userObject);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ClassVisualizerView.this.treeMousePressedOrReleased(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ClassVisualizerView.this.treeMousePressedOrReleased(e);
        }
    }

    private class CustomTreeSelectionListener
    implements TreeSelectionListener {
        private CustomTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath treePath = e.getNewLeadSelectionPath();
            if (treePath != null) {
                TreeNode clickedNode = (TreeNode)treePath.getLastPathComponent();
                Object userObject = clickedNode instanceof ClassPresentationWrapper ? ((ClassPresentationWrapper)clickedNode).class_ : ((DefaultMutableTreeNode)clickedNode).getUserObject();
                ClassVisualizerView.this.viewClassAction(userObject);
            }
        }
    }

    private static class CustomTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public CustomTreeCellRenderer() {
            this.setLeafIcon(null);
            this.setOpenIcon(null);
            this.setClosedIcon(null);
            this.setTextSelectionColor(Color.BLACK);
            this.setTextNonSelectionColor(Color.BLACK);
            this.setBackgroundSelectionColor(TREE_SELECTION_BG_COLOR);
        }
    }

    private static class ClassesTableCellRenderer
    extends DefaultTableCellRenderer {
        private ClassesTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Integer) {
                component.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
            ClassesTableModel model = (ClassesTableModel)table.getModel();
            Class_ class_ = model.getRow(table.convertRowIndexToModel(row));
            if (isSelected) {
                component.setForeground(Color.WHITE);
                component.setBackground(Color.BLUE);
            } else {
                component.setForeground(Color.BLACK);
                component.setBackground(value instanceof String ? Utils.backgroundColorMap.get((Object)class_.kind) : Color.WHITE);
            }
            return component;
        }
    }

    private class ClassesTableMouseListener
    extends MouseAdapter {
        private ClassesTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            JTable table = (JTable)evt.getSource();
            int rowIdx = table.rowAtPoint(new Point(evt.getX(), evt.getY()));
            if (rowIdx > -1) {
                ClassesTableModel model = (ClassesTableModel)table.getModel();
                Class_ clickedObject = model.getRow(table.convertRowIndexToModel(rowIdx));
                int clickCount = evt.getClickCount();
                if (clickCount == 2) {
                    ClassVisualizerView.this.selectClassAction(clickedObject);
                }
            }
        }
    }

    private class ClassesTableSelectionListener
    implements ListSelectionListener {
        private JTable table;

        public ClassesTableSelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int rowIdx = lsm.getLeadSelectionIndex();
            if (rowIdx > -1 && !e.getValueIsAdjusting()) {
                ClassesTableModel model = (ClassesTableModel)this.table.getModel();
                Class_ class_ = model.getRow(this.table.convertRowIndexToModel(rowIdx));
                ClassVisualizerView.this.viewClassAction(class_);
            }
        }
    }

    private static class ClassesTableRowFilter
    extends RowFilter<ClassesTableModel, Integer> {
        private String filter = "";

        private ClassesTableRowFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends ClassesTableModel, ? extends Integer> entry) {
            return entry.getModel().getRow((int)entry.getIdentifier().intValue()).fullTypeName.contains(this.filter);
        }
    }

    private static class ClassesTableModel
    extends AbstractTableModel {
        private static final String[] COLUMN_NAMES = new String[]{"Idx", "Name", "Full Name"};
        private final List<Class_> classes_;
        private final boolean withIndexes;

        public ClassesTableModel() {
            this.withIndexes = true;
            this.classes_ = new ArrayList<Class_>(128);
        }

        public ClassesTableModel(Collection<Class_> classes_) {
            this.withIndexes = false;
            this.classes_ = new ArrayList<Class_>(classes_);
            Collections.sort(this.classes_);
        }

        @Override
        public int getRowCount() {
            return this.classes_.size();
        }

        @Override
        public int getColumnCount() {
            return this.withIndexes ? COLUMN_NAMES.length : COLUMN_NAMES.length - 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[this.withIndexes ? columnIndex : columnIndex + 1];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.withIndexes && columnIndex == 0 ? Integer.class : String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (!this.withIndexes) {
                ++columnIndex;
            }
            switch (columnIndex) {
                case 0: {
                    return rowIndex + 1;
                }
                case 1: {
                    return this.classes_.get((int)rowIndex).name;
                }
                case 2: {
                    return this.classes_.get((int)rowIndex).fullTypeName;
                }
            }
            throw new RuntimeException("Wrong columnIndex: " + columnIndex);
        }

        public boolean addRow(Class_ class_) {
            return this.classes_.add(class_);
        }

        public Class_ getRow(int idx) {
            return this.classes_.get(idx);
        }
    }

    static enum TreeAction {
        EXPAND,
        COLLAPSE,
        EXPAND_CLASS;

    }
}

