/*
 * Decompiled with CFR 0.152.
 */
package clsvis.gui.graph;

import clsvis.Utils;
import clsvis.gui.ColorContext;
import clsvis.gui.StructureBuilder;
import clsvis.gui.graph.Edge;
import clsvis.gui.graph.EdgeLineStyle;
import clsvis.gui.graph.SideGraphLayoutBuilder;
import clsvis.gui.graph.Vertex;
import clsvis.model.Class_;
import clsvis.model.RelationType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class GraphComponent
extends JPanel
implements Scrollable {
    private static final Logger logger = Logger.getLogger(GraphComponent.class.getName());
    private static final BasicStroke border = new BasicStroke(2.0f);
    private static final BasicStroke solidLine = new BasicStroke(1.0f);
    private static final BasicStroke dashedLine = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
    private static final SideGraphLayoutBuilder layoutBuilder = new SideGraphLayoutBuilder();
    private int size = 12;
    private Font classFont = new Font("SansSerif", 1, this.size);
    private Font abstractClassFont = new Font("SansSerif", 3, this.size);
    private Color selectedClassForeground = Color.red;
    private Color classForeground;
    private Color classUnprocessedForeground;
    private Class_ mainClass;
    private Vertex selectedVertex;
    private Vertex prevSelectedVertex;
    private PaintAction paintAction;
    private int cellPadding;
    private int cellSpacing;
    private List<Vertex> vertices;
    private List<Edge> edges;

    public GraphComponent() {
        this.classForeground = new Color(ColorContext.ClassProcessed.colotInt);
        this.classUnprocessedForeground = new Color(ColorContext.ClassUnprocessed.colotInt);
        this.cellPadding = this.size;
        this.cellSpacing = this.size;
        this.vertices = Collections.EMPTY_LIST;
        this.edges = Collections.EMPTY_LIST;
    }

    private void prepareLayout() {
        logger.finest("---- prepareLayout");
        this.vertices = new ArrayList<Vertex>(1024);
        this.edges = new ArrayList<Edge>(1024);
        Dimension graphSize = this.getPreferredSize();
        layoutBuilder.buildGraphLayout(this.mainClass, this.vertices, this.edges, graphSize, this.cellPadding, this.cellSpacing, this.getFontMetrics(this.classFont), this.getFontMetrics(this.abstractClassFont));
        this.setPreferredSize(graphSize);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.getClass().getSimpleName() + ".paintComponent");
        }
        long timeStart = System.currentTimeMillis();
        super.paintComponent(g2);
        this.paintGraph(g2);
        if (this.paintAction == PaintAction.SELECTED_ITEM) {
            this.paintSelection(g2);
        }
        this.paintAction = null;
        long timeStop = System.currentTimeMillis();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format("-- painting time: %dms", timeStop - timeStart));
        }
    }

    private void paintGraph(Graphics2D g2) {
        g2.setColor(this.classForeground);
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            this.drawEdge2(g2, this.edges.get(i));
        }
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        g2.setStroke(border);
        for (Vertex vertex : this.vertices) {
            if (this.selectedVertex == null && vertex.main) {
                this.prevSelectedVertex = this.selectedVertex = vertex;
            }
            if (vertex.isRepresentsClass()) {
                g2.setColor(Utils.backgroundColorMap.get((Object)vertex.class_.kind));
                g2.fill(vertex);
            }
            g2.setColor(!vertex.class_.relationsProcessed && vertex.isRepresentsClass() ? this.classUnprocessedForeground : this.classForeground);
            g2.setFont(vertex.class_.isAbstract() && vertex.isRepresentsClass() ? this.abstractClassFont : this.classFont);
            g2.drawString(vertex.getTitle(), vertex.textX, vertex.textY);
            this.drawVertexOutline(g2, vertex);
        }
    }

    private void paintSelection(Graphics2D g2) {
        g2.setStroke(border);
        this.drawVertexOutline(g2, this.prevSelectedVertex);
        this.drawVertexOutline(g2, this.selectedVertex);
        this.prevSelectedVertex = this.selectedVertex;
    }

    private void drawVertexOutline(Graphics2D g2, Vertex vertex) {
        g2.setColor(vertex == this.selectedVertex ? this.selectedClassForeground : this.classForeground);
        g2.draw(vertex);
    }

    private void drawEdge2(Graphics2D g2, Edge edge) {
        g2.setColor(edge.relationType == RelationType.DependencyThrows ? this.selectedClassForeground : this.classForeground);
        g2.setStroke(edge.lineStyle == EdgeLineStyle.Solid ? solidLine : dashedLine);
        int connectorCount = edge.connector.size();
        g2.draw(edge.connector.get(connectorCount - 1));
        g2.setStroke(solidLine);
        for (int i = connectorCount - 2; i >= 0; --i) {
            g2.draw(edge.connector.get(i));
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Vertex vertex = this.vertexAtPoint(event.getX(), event.getY());
        return vertex != null && vertex.isRepresentsClass() ? StructureBuilder.buildClassRelationsSummaryTable(vertex.class_) : null;
    }

    private Vertex vertexAtPoint(int x, int y) {
        for (Vertex vertex : this.vertices) {
            if (!vertex.contains(x, y)) continue;
            return vertex;
        }
        return null;
    }

    public Class_ getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(Class_ mainClass) {
        this.mainClass = mainClass;
        this.paintAction = PaintAction.GRAPH;
        this.selectedVertex = null;
        this.prevSelectedVertex = null;
        this.prepareLayout();
        this.revalidate();
        this.repaint();
    }

    public Class_ selectVertexAt(int x, int y) {
        Vertex selectedVertex = this.vertexAtPoint(x, y);
        if (selectedVertex != null && selectedVertex != this.prevSelectedVertex && selectedVertex.isRepresentsClass()) {
            this.selectedVertex = selectedVertex;
            this.paintAction = PaintAction.SELECTED_ITEM;
            this.repaint();
        }
        return selectedVertex != null ? selectedVertex.class_ : null;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (this.vertices.isEmpty() ? 0 : (orientation == 1 ? this.vertices.get((int)0).height : this.vertices.get((int)0).width)) + this.cellSpacing;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (orientation == 1 ? visibleRect.height : visibleRect.width) - this.cellSpacing;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private static enum PaintAction {
        GRAPH,
        SELECTED_ITEM;

    }
}

