/*
 * Decompiled with CFR 0.152.
 */
package clsvis.gui.graph;

import clsvis.gui.graph.Edge;
import clsvis.gui.graph.EdgeLineStyle;
import clsvis.gui.graph.EdgePosition;
import clsvis.gui.graph.Vertex;
import clsvis.gui.graph.VertexPlacement;
import clsvis.model.Class_;
import clsvis.model.ElementModifier;
import clsvis.model.RelationDirection;
import clsvis.model.RelationType;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FontMetrics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

class SideGraphLayoutBuilder {
    private static final Logger logger = Logger.getLogger(SideGraphLayoutBuilder.class.getName());
    private static final RelationType[] relationTypes = new RelationType[]{RelationType.SuperInterface, RelationType.SuperClass, RelationType.InnerClass, RelationType.InnerClass, RelationType.Association, RelationType.Dependency, RelationType.DependencyThrows, RelationType.Association, RelationType.Dependency, RelationType.DependencyThrows};
    private static final RelationDirection[] relationDirections = new RelationDirection[]{RelationDirection.Inbound, RelationDirection.Inbound, RelationDirection.Outbound, RelationDirection.Inbound, RelationDirection.Outbound, RelationDirection.Outbound, RelationDirection.Outbound, RelationDirection.Inbound, RelationDirection.Inbound, RelationDirection.Inbound};
    private static Dimension maxGraphSize;

    SideGraphLayoutBuilder() {
        int width = 0;
        int height = 0;
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            DisplayMode dm = gd.getDisplayMode();
            if (dm.getWidth() * dm.getHeight() <= width * height) continue;
            width = dm.getWidth();
            height = dm.getHeight();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format("#### max screen size: %d x %d", width, height));
        }
        maxGraphSize = new Dimension(width, height);
    }

    public void buildGraphLayout(Class_ class_, Collection<Vertex> vertices, Collection<Edge> edges, Dimension dimension, int cellPadding, int cellSpacing, FontMetrics classFM, FontMetrics abstractClassFM) {
        ArrayList<Vertex> rowTopVerts = new ArrayList<Vertex>(16);
        ArrayList<Vertex> rowCenterVerts = new ArrayList<Vertex>(1);
        ArrayList<Vertex> rowBottomVerts = new ArrayList<Vertex>(128);
        ArrayList<Vertex> colLeftVerts = new ArrayList<Vertex>(512);
        ArrayList<Vertex> colRightVerts = new ArrayList<Vertex>(512);
        Collection[] verticesTbl = new Collection[]{rowBottomVerts, rowBottomVerts, colRightVerts, colLeftVerts, colRightVerts, colRightVerts, colRightVerts, colLeftVerts, colLeftVerts, colLeftVerts};
        HashSet<Class_> usedClasses = new HashSet<Class_>();
        ArrayList<Class_> generalizations1 = new ArrayList<Class_>(8);
        ArrayList<Class_> generalizations2 = new ArrayList<Class_>(8);
        Collection<Class_> superInterfaces = class_.getRelations(RelationType.SuperInterface, RelationDirection.Outbound);
        int generCount = superInterfaces.size();
        int generIdx = 0;
        for (Class_ superInterface : superInterfaces) {
            if (++generIdx > generCount >> 1) {
                generalizations2.add(superInterface);
                continue;
            }
            generalizations1.add(superInterface);
        }
        Vertex mainClassVertex = SideGraphLayoutBuilder.createVertex(class_, cellPadding, classFM, abstractClassFM, null);
        mainClassVertex.main = true;
        rowCenterVerts.add(mainClassVertex);
        SideGraphLayoutBuilder.createVerticesAndEdges(generalizations1, usedClasses, RelationType.SuperInterface, RelationDirection.Outbound, EdgePosition.Vertical, mainClassVertex, rowTopVerts, edges, cellPadding, cellSpacing, classFM, abstractClassFM);
        SideGraphLayoutBuilder.createVerticesAndEdges(class_.getRelations(RelationType.SuperClass, RelationDirection.Outbound), usedClasses, RelationType.SuperClass, RelationDirection.Outbound, EdgePosition.Vertical, mainClassVertex, rowTopVerts, edges, cellPadding, cellSpacing, classFM, abstractClassFM);
        SideGraphLayoutBuilder.createVerticesAndEdges(generalizations2, usedClasses, RelationType.SuperInterface, RelationDirection.Outbound, EdgePosition.Vertical, mainClassVertex, rowTopVerts, edges, cellPadding, cellSpacing, classFM, abstractClassFM);
        for (int i = 0; i < relationTypes.length; ++i) {
            SideGraphLayoutBuilder.createVerticesAndEdges(class_.getRelations(relationTypes[i], relationDirections[i]), usedClasses, relationTypes[i], relationDirections[i], SideGraphLayoutBuilder.getEdgePosition(relationTypes[i]), mainClassVertex, verticesTbl[i], edges, cellPadding, cellSpacing, classFM, abstractClassFM);
        }
        int minReqWidth = mainClassVertex.width + cellSpacing * 20;
        int minReqHeight = mainClassVertex.height + cellSpacing * 20;
        int[] rowTopSums = SideGraphLayoutBuilder.summarizeSizes(rowTopVerts, cellSpacing);
        int[] rowBottomSums = SideGraphLayoutBuilder.summarizeSizes(rowBottomVerts, cellSpacing);
        int[] colLeftSums = SideGraphLayoutBuilder.summarizeSizes(colLeftVerts, cellSpacing);
        int[] colRightSums = SideGraphLayoutBuilder.summarizeSizes(colRightVerts, cellSpacing);
        minReqWidth = Math.max(minReqWidth, rowTopSums[2]);
        minReqWidth = Math.max(minReqWidth, rowBottomSums[2]);
        minReqWidth += SideGraphLayoutBuilder.specialSum(colLeftSums[0], colRightSums[0], cellSpacing);
        minReqHeight = Math.max(minReqHeight, colLeftSums[3]);
        minReqHeight = Math.max(minReqHeight, colRightSums[3]);
        minReqHeight += SideGraphLayoutBuilder.specialSum(rowTopSums[1], rowBottomSums[1], cellSpacing);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format("---- computed sizes: min:[%d,%d], pref:[%d,%d]", minReqWidth, minReqHeight, dimension.width, dimension.height));
        }
        int areaWidth = Math.max(dimension.width - 20, minReqWidth);
        int areaHeight = Math.max(dimension.height - 20, minReqHeight);
        dimension.setSize(areaWidth, areaHeight);
        int centerX = areaWidth / 2;
        int centerY = areaHeight / 2;
        SideGraphLayoutBuilder.positionRowVertices(rowTopVerts, VertexPlacement.Top, areaWidth, areaHeight, cellSpacing);
        SideGraphLayoutBuilder.positionRowVertices(rowBottomVerts, VertexPlacement.Bottom, areaWidth, areaHeight, cellSpacing);
        SideGraphLayoutBuilder.positionColumnVertices(colLeftVerts, VertexPlacement.Left, areaWidth, areaHeight, cellSpacing);
        SideGraphLayoutBuilder.positionColumnVertices(colRightVerts, VertexPlacement.Right, areaWidth, areaHeight, cellSpacing);
        mainClassVertex.setLocation(centerX - mainClassVertex.width / 2, centerY - mainClassVertex.height / 2);
        SideGraphLayoutBuilder.positionEdges(edges, cellSpacing);
        vertices.addAll(rowTopVerts);
        vertices.addAll(rowCenterVerts);
        vertices.addAll(rowBottomVerts);
        vertices.addAll(colLeftVerts);
        vertices.addAll(colRightVerts);
        for (Collection coll : new Collection[]{rowTopVerts, rowBottomVerts, colLeftVerts, colRightVerts}) {
            coll.clear();
        }
    }

    private static void positionRowVertices(Collection<Vertex> vertices, VertexPlacement placement, int areaWidth, int areaHeight, int cellSpacing) {
        if (vertices.isEmpty()) {
            return;
        }
        int centerX = areaWidth / 2;
        int[] sizes = SideGraphLayoutBuilder.summarizeSizes(vertices, cellSpacing);
        int totalWidth = sizes[2];
        int maxHeight = sizes[1];
        int currX = centerX - totalWidth / 2 + cellSpacing;
        for (Vertex vertex : vertices) {
            int y = placement == VertexPlacement.Top ? maxHeight - vertex.height : areaHeight - maxHeight;
            vertex.setLocation(currX, y);
            currX += vertex.width + cellSpacing;
        }
    }

    private static void positionColumnVertices(Collection<Vertex> vertices, VertexPlacement placement, int areaWidth, int areaHeight, int cellSpacing) {
        if (vertices.isEmpty()) {
            return;
        }
        int centerY = areaHeight / 2;
        int[] sizes = SideGraphLayoutBuilder.summarizeSizes(vertices, cellSpacing);
        int totalHeight = sizes[3];
        int maxWidth = sizes[0];
        int currY = centerY - totalHeight / 2 + cellSpacing;
        for (Vertex vertex : vertices) {
            int x = placement == VertexPlacement.Left ? maxWidth - vertex.width : areaWidth - maxWidth;
            vertex.setLocation(x, currY);
            currY += vertex.height + cellSpacing;
        }
    }

    private static void positionEdges(Collection<Edge> edges, int cellSpacing) {
        for (Edge edge : edges) {
            int y3;
            int x3;
            int y2;
            int x2;
            int y1;
            int x1;
            ArrayList<Shape> connector = new ArrayList<Shape>(3);
            Path2D.Double path = new Path2D.Double();
            if (SideGraphLayoutBuilder.isVerticalOrientation(edge)) {
                x1 = (int)edge.fromVertex.getCenterX();
                y1 = edge.fromVertex.y;
                x2 = (int)edge.toVertex.getCenterX();
                y2 = edge.toVertex.y + edge.toVertex.height + cellSpacing;
                x3 = x2;
                y3 = y2 - cellSpacing;
                ((Path2D)path).moveTo(x3, y3);
                ((Path2D)path).lineTo(x3 - cellSpacing / 2, y2);
                ((Path2D)path).lineTo(x3 + cellSpacing / 2, y2);
                path.closePath();
            } else {
                x1 = edge.fromVertex.x + edge.fromVertex.width + cellSpacing;
                y1 = !(!edge.fromVertex.main || edge.fromVertex.class_.getRelations(RelationType.InnerClass, RelationDirection.Outbound).isEmpty() || edge.fromVertex.class_.getRelations(RelationType.Association, RelationDirection.Outbound).isEmpty() && edge.fromVertex.class_.getRelations(RelationType.Dependency, RelationDirection.Outbound).isEmpty() && edge.fromVertex.class_.getRelations(RelationType.DependencyThrows, RelationDirection.Outbound).isEmpty()) ? (edge.relationType == RelationType.InnerClass ? edge.fromVertex.y + cellSpacing / 2 : edge.fromVertex.y + edge.fromVertex.height - cellSpacing / 2) : (int)edge.fromVertex.getCenterY();
                x2 = edge.toVertex.x - cellSpacing;
                y2 = (int)edge.toVertex.getCenterY();
                x3 = x2 + cellSpacing;
                y3 = y2;
                ((Path2D)path).moveTo(x3, y3);
                ((Path2D)path).lineTo(x2, y2);
                if (edge.relationType != RelationType.Association || !edge.toVertex.class_.getRelations(RelationType.Association, RelationDirection.Outbound).contains(edge.fromVertex.class_)) {
                    ((Path2D)path).moveTo(x3, y3);
                    ((Path2D)path).lineTo(x2 + 3, y3 - cellSpacing / 2);
                    ((Path2D)path).moveTo(x3, y3);
                    ((Path2D)path).lineTo(x2 + 3, y3 + cellSpacing / 2);
                }
                int x4 = x1 - cellSpacing;
                int y4 = y1;
                if (edge.relationType == RelationType.InnerClass) {
                    int y5 = y4 - cellSpacing / 2;
                    connector.add(new Arc2D.Double(x4, y5, cellSpacing, cellSpacing, 0.0, 360.0, 1));
                    int x6 = x1 - cellSpacing / 2;
                    ((Path2D)path).moveTo(x6, y5);
                    ((Path2D)path).lineTo(x6, y5 + cellSpacing);
                }
                ((Path2D)path).moveTo(x4, y4);
                ((Path2D)path).lineTo(x1, y4);
            }
            connector.add(path);
            connector.add(new Line2D.Double(x1, y1, x2, y2));
            edge.connector = connector;
            edge.lineStyle = SideGraphLayoutBuilder.isVerticalOrientation(edge) && !edge.fromVertex.class_.modifiers.contains((Object)ElementModifier.Interface) && edge.toVertex.class_.modifiers.contains((Object)ElementModifier.Interface) || edge.relationType == RelationType.Dependency || edge.relationType == RelationType.DependencyThrows ? EdgeLineStyle.Dashed : EdgeLineStyle.Solid;
        }
    }

    private static int[] summarizeSizes(Collection<Vertex> vertices, int cellSpacing) {
        int minWidth = 0;
        int minHeight = 0;
        int sumWidth = 0;
        int sumHeight = 0;
        for (Vertex vertex : vertices) {
            minWidth = Math.max(minWidth, vertex.width + cellSpacing);
            minHeight = Math.max(minHeight, vertex.height + cellSpacing);
            sumWidth += vertex.width + cellSpacing;
            sumHeight += vertex.height + cellSpacing;
        }
        return new int[]{minWidth + cellSpacing, minHeight + cellSpacing, sumWidth + cellSpacing, sumHeight + cellSpacing};
    }

    private static int specialSum(int val1, int val2, int boundery) {
        return Math.max(val1, val2) << 1;
    }

    private static void createVerticesAndEdges(Collection<Class_> targetClasses, Collection<Class_> usedClasses, RelationType relationType, RelationDirection direction, EdgePosition position, Vertex mainClassVertex, Collection<Vertex> vertices, Collection<Edge> edges, int cellPadding, int cellSpacing, FontMetrics classFM, FontMetrics abstractClassFM) {
        boolean tooManyClasses;
        boolean bl = relationType == RelationType.SuperClass || relationType == RelationType.SuperInterface ? (mainClassVertex.width + cellSpacing) * (targetClasses.size() + 2) > SideGraphLayoutBuilder.maxGraphSize.width : (tooManyClasses = (mainClassVertex.height + cellSpacing) * (targetClasses.size() + 2) > SideGraphLayoutBuilder.maxGraphSize.height);
        if (tooManyClasses) {
            SideGraphLayoutBuilder.createVertexAndEdge(mainClassVertex.class_, relationType, direction, position, mainClassVertex, vertices, edges, cellPadding, classFM, abstractClassFM, String.valueOf(targetClasses.size()) + " classes");
        } else {
            for (Class_ targetClass : targetClasses) {
                if (!usedClasses.add(targetClass)) continue;
                SideGraphLayoutBuilder.createVertexAndEdge(targetClass, relationType, direction, position, mainClassVertex, vertices, edges, cellPadding, classFM, abstractClassFM, null);
            }
        }
    }

    private static void createVertexAndEdge(Class_ targetClass, RelationType relationType, RelationDirection direction, EdgePosition position, Vertex mainClassVertex, Collection<Vertex> vertices, Collection<Edge> edges, int cellPadding, FontMetrics classFM, FontMetrics abstractClassFM, String title) {
        Vertex targetVertex = SideGraphLayoutBuilder.createVertex(targetClass, cellPadding, classFM, abstractClassFM, title);
        Edge edge = direction == RelationDirection.Outbound ? new Edge(mainClassVertex, targetVertex, relationType, position) : new Edge(targetVertex, mainClassVertex, relationType, position);
        vertices.add(targetVertex);
        edges.add(edge);
    }

    private static Vertex createVertex(Class_ class_, int cellPadding, FontMetrics classFM, FontMetrics abstractClassFM, String title) {
        FontMetrics fm = title == null && class_.isAbstract() ? abstractClassFM : classFM;
        return new Vertex(0, 0, fm.stringWidth(title != null ? title : class_.name), fm.getHeight(), fm.getAscent(), cellPadding, class_, title);
    }

    private static EdgePosition getEdgePosition(RelationType relType) {
        return relType == RelationType.SuperClass || relType == RelationType.SuperInterface ? EdgePosition.Vertical : EdgePosition.Horizontal;
    }

    private static boolean isVerticalOrientation(Edge edge) {
        return edge.relationType == RelationType.SuperClass || edge.relationType == RelationType.SuperInterface;
    }
}

