/*
 * Decompiled with CFR 0.152.
 */
package clsvis.model;

public enum ElementKind {
    Class(0xFFF2CC),
    Interface(0xCCFFCC),
    Enum(0xCCCCFF),
    AnnotationType(0xFECCFF),
    Throwable(16752512),
    Extends(0x4F4F4F, '\u25b2'),
    Implements(0xA9A9A9, '\u25b2'),
    Constants(0xFF6F60, '\u25a0'),
    Fields(10537448, '\u25a0'),
    Properties(4879009, '\u25a0'),
    Constructors(16753920, '\u2666'),
    Methods(0xFF00FF, '\u2666'),
    Annotations(0xFECCFF, '\u25cf'),
    Parameters(32896, '\u25cf'),
    Throws(0xA90000, '\u25cf');

    public final int colorNum;
    public final String symbolStr;
    public final String titleWithSymbolStr;
    private static final String CLASS_TEMPLATE = "<span style=\"background-color: #%s; color: black\">&nbsp;<code><b>%c</b></code>&nbsp;</span>";
    private static final String MEMBER_TEMPLATE = "<span color=%s>&nbsp;<code>%c</code> </span>";
    private static final char CLASS_INDICATOR = '\u0000';

    private ElementKind(int color) {
        this(color, '\u0000');
    }

    private ElementKind(int color, char symbol) {
        String template;
        this.colorNum = color;
        if (symbol == '\u0000') {
            symbol = this.name().charAt(0);
            template = CLASS_TEMPLATE;
        } else {
            template = MEMBER_TEMPLATE;
        }
        this.symbolStr = String.format(template, ElementKind.colorAsRRGGBB(Integer.toHexString(color)), Character.valueOf(symbol));
        this.titleWithSymbolStr = this.symbolStr + this.name();
    }

    private static String colorAsRRGGBB(String colorHex) {
        while (colorHex.length() < 6) {
            colorHex = "0" + colorHex;
        }
        return colorHex;
    }
}

