/*
 * Decompiled with CFR 0.152.
 */
package clsvis.model;

import clsvis.model.ElementKind;
import clsvis.model.ElementModifier;
import clsvis.model.ElementVisibility;
import clsvis.model.ParameterizableElement;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;

public class Operation
extends ParameterizableElement {
    public final List<ParameterizableElement> parameters;
    public final List<ParameterizableElement> throwables;

    public Operation(String id, String name, Class type, Type genericType, Collection<ElementModifier> modifiers, ElementKind kind, ElementVisibility visibility, List<ParameterizableElement> parameters, List<ParameterizableElement> throwables) {
        super(id, name, type, genericType, modifiers, kind, visibility);
        this.parameters = parameters;
        this.throwables = throwables;
    }

    public String getParametersAsString() {
        if (this.parameters.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(256);
        for (ParameterizableElement parameter : this.parameters) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(parameter.shortTypeName);
        }
        return sb.toString();
    }

    @Override
    public String getSignature() {
        return this.name + "( " + this.getParametersAsString() + " )";
    }
}

