/*
 * Decompiled with CFR 0.152.
 */
package clsvis.model;

import clsvis.model.RelationDirection;
import java.util.EnumMap;
import java.util.Map;

public enum RelationType {
    SuperClass("&nbsp;&uarr;", "&nbsp;&darr;"),
    SuperInterface("&nbsp;&uarr;", "&nbsp;&darr;", "#A9A9A9"),
    InnerClass("&oplus;", "&otimes;"),
    Association("&rarr;", "&larr;"),
    Dependency("&rarr;", "&larr;", "#A9A9A9"),
    DependencyThrows("&rarr;", "&larr;", "#A90000");

    public final Map<RelationDirection, String> asString = new EnumMap<RelationDirection, String>(RelationDirection.class);

    private RelationType(String toSymbol, String fromSymbol) {
        this(toSymbol, fromSymbol, null);
    }

    private RelationType(String toSymbol, String fromSymbol, String color) {
        this.asString.put(RelationDirection.Outbound, RelationType.asString(toSymbol, color));
        this.asString.put(RelationDirection.Inbound, RelationType.asString(fromSymbol, color));
    }

    private static String asString(String symbol, String color) {
        return color == null ? symbol + ' ' : String.format("<span color=%s>%s</span> ", color, symbol);
    }
}

