/*
 * Decompiled with CFR 0.152.
 */
package clsvis.process.importer;

import clsvis.process.importer.CompiledClassImporter;
import clsvis.process.importer.ImportException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BaseProjectImporter {
    private static final Logger logger = Logger.getLogger(BaseProjectImporter.class.getName());
    public static final String jarFileName = ".jar";
    private static final String classFileSuffix = ".class";
    protected final CompiledClassImporter classImporter = new CompiledClassImporter();
    protected final Collection<File> classPaths = new LinkedHashSet<File>();
    protected final List<String> classNames = new ArrayList<String>(16384);

    public void importProject(File ... paths) {
        this.classNames.clear();
        try {
            Runtime runtime = Runtime.getRuntime();
            logger.log(Level.FINE, "Used memory before import: {0} MB", runtime.totalMemory() - runtime.freeMemory() >> 20);
            this.findClassNames(paths);
            logger.log(Level.CONFIG, "Project size: {0} top-level classes", this.classNames.size());
            if (!this.classNames.isEmpty()) {
                this.classPaths.addAll(Arrays.asList(paths));
                this.initClassLoader();
                this.runClassesImport();
                logger.log(Level.FINE, "Used memory after import: {0} MB", runtime.totalMemory() - runtime.freeMemory() >> 20);
            }
        }
        catch (IOException e) {
            BaseProjectImporter.logThrowable(e);
            throw new ImportException(e);
        }
        catch (ImportException e) {
            throw e;
        }
        catch (RuntimeException e) {
            BaseProjectImporter.logThrowable(e);
            throw e;
        }
        catch (Error e) {
            BaseProjectImporter.logThrowable(e);
            throw e;
        }
    }

    public void cleanupAfterImport() {
        this.classImporter.setImportProgressListener(null);
        this.classImporter.setClassLoader(null);
        this.classNames.clear();
    }

    private void findClassNamesInDirectory(File classesDir, Collection<String> subDirNames) {
        File currPath = classesDir;
        for (String subDirName : subDirNames) {
            currPath = new File(currPath, subDirName);
        }
        String currPathName = currPath.getPath();
        if (currPathName.startsWith(".")) {
            return;
        }
        if (currPath.isDirectory()) {
            for (String dirEntryName : currPath.list()) {
                ArrayList<String> newSubDirNames = new ArrayList<String>(subDirNames);
                newSubDirNames.add(dirEntryName);
                this.findClassNamesInDirectory(classesDir, newSubDirNames);
            }
        } else if (BaseProjectImporter.isTopLevelClass(currPathName)) {
            StringBuilder classNameSB = new StringBuilder(128);
            for (String subDirName : subDirNames) {
                classNameSB.append(subDirName).append('.');
            }
            classNameSB.setLength(classNameSB.length() - 7);
            this.classNames.add(classNameSB.toString());
        }
    }

    private void findClassNamesInJarFile(File jarFile) throws IOException {
        Enumeration<? extends ZipEntry> zipEntries = new ZipFile(jarFile).entries();
        while (zipEntries.hasMoreElements()) {
            String entryName = zipEntries.nextElement().getName();
            if (!BaseProjectImporter.isTopLevelClass(entryName)) continue;
            this.classNames.add(entryName.replace('/', '.').substring(0, entryName.length() - 6));
        }
    }

    protected void findClassNames(File ... paths) throws IOException {
        for (File path : paths) {
            this.findClassNames(path);
        }
    }

    protected void findClassNames(File path) throws IOException {
        if (path == null) {
            throw new IOException("No path available");
        }
        BaseProjectImporter.checkPathExists(path);
        if (path.isDirectory()) {
            this.findClassNamesInDirectory(path, Collections.EMPTY_LIST);
        } else if (path.getName().endsWith(jarFileName)) {
            this.findClassNamesInJarFile(path);
        } else {
            throw new IOException(String.format("Unsupported type of path '%s'", path.getName()));
        }
    }

    private static boolean isTopLevelClass(String entry) {
        return entry.endsWith(classFileSuffix) && !entry.contains("$");
    }

    protected void initClassLoader() {
        ArrayList<URL> classpathURLs = new ArrayList<URL>(this.classPaths.size());
        for (File classPath : this.classPaths) {
            try {
                if (!classPath.exists()) {
                    logger.warning(String.format("Classpath entry '%s' doesn't exist", classPath.getPath()));
                }
                classpathURLs.add(classPath.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                logger.log(Level.WARNING, String.format("Problem during processing classpath entry '%s':", classPath.getPath()), ex);
            }
        }
        URLClassLoader classLoader = new URLClassLoader(classpathURLs.toArray(new URL[classpathURLs.size()]));
        this.classImporter.setClassLoader(classLoader);
    }

    protected void runClassesImport() {
        this.classImporter.importClasses(this.classNames);
    }

    protected static void checkPathExists(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getPath());
        }
    }

    protected static void logThrowable(Throwable t) {
        logger.throwing("", "", t);
    }

    public CompiledClassImporter getClassImporter() {
        return this.classImporter;
    }

    public Collection<String> getClassNames() {
        return this.classNames;
    }

    public Collection<File> getClassPaths() {
        return this.classPaths;
    }

    public void addClassPaths(File ... paths) {
        for (File path : paths) {
            try {
                BaseProjectImporter.checkPathExists(path);
                this.classPaths.add(path);
            }
            catch (FileNotFoundException ex) {
                logger.log(Level.WARNING, "Problem during adding element to class path: {0}", ex.toString());
                BaseProjectImporter.logThrowable(ex);
            }
        }
    }
}

