@echo off
rem
rem ClassVisualizer start script.
rem
rem This is a template, which can be copied and customized per project.
rem
rem invokation: clsvis.bat [-cp classpath_to_add] [path_to_import]
rem
set DIR=%~dp0
set LIB_PATH=%DIR%\clsvis.jar
set IMPORT_PATH=

rem
rem Set project library path from eventual parameters
rem
if "%1" == "-cp" (
	set LIB_PATH=%LIB_PATH%;%2
	shift
	shift
)

rem
rem Set project paths: library path (class path) and import path.
rem
rem set PROJECT_EAR=C:/my_project/module-ear/target/app-ear
rem set LIB_PATH=%LIB_PATH%;%PROJECT_EAR%/lib/*
rem set PROJECT_WAR=C:/my_project/module-web/target/app-web/WEB-INF
rem set LIB_PATH=%LIB_PATH%;%PROJECT_WAR%/lib/*
rem set IMPORT_PATH=%PROJECT_WAR%/lib/app-*.jar %PROJECT_WAR%/classes

rem
rem Set application server path and add its libraries to library path (class path).
rem
rem set APP_SERVER=C:/glassfish/glassfish
rem set LIB_PATH=%LIB_PATH%;%APP_SERVER%/modules/*
rem set LIB_PATH=%LIB_PATH%;%APP_SERVER%/lib/*

rem
rem Choose java - use JAVA_HOME, if set.
rem
if "%JAVA_HOME%" == "" (
	set JAVA=java
) else (
	set JAVA=%JAVA_HOME%/bin/java
)

rem
rem Choose Look and Feel.
rem
rem No explicit settings - java default (Ocean)
rem set LAF=
rem Windows default
set LAF=com.sun.java.swing.plaf.windows.WindowsLookAndFeel
rem Windows classic
rem set LAF=com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel
rem modern one - Nimbus
rem set LAF=com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel

rem
rem Final settings and run.
rem
rem Look and Feel
set OPTS=
if not "%LAF%" == "" (
	set OPTS=-Dswing.defaultlaf=%LAF%
)
rem Memory
set OPTS=%OPTS% -Xmx384m -XX:MaxPermSize=128m
rem import path - workaround for bug in shift: not working with %*
:setupImportPath
if "%1" == "" goto setupImportDone
set IMPORT_PATH=%IMPORT_PATH% %1
shift
:setupImportDone

rem
rem Run.
rem
set CMD="%JAVA%" %OPTS% -cp "%LIB_PATH%" clsvis.gui.ClassVisualizer %IMPORT_PATH%
echo %CMD%
%CMD%
