#!/bin/bash
#
# ClassVisualizer start script.
#
# This is a template, which can be copied and customized per project.
#
# invokation: clsvis.sh [-cp classpath_to_add] [path_to_import]
#
DIR=`dirname "$0"`
LIB_PATH="$DIR/clsvis.jar"

#
# Set project paths from eventual parameters: library path (class path) and import path.
#
if [ "$1" == "-cp" ]; then
	LIB_PATH="$LIB_PATH:$2"
	shift 2
fi

#
# Set project paths: library path (class path) and import path.
#
#PROJECT_EAR=~/my_project/module-ear/target/app-ear
#LIB_PATH="$LIB_PATH:$PROJECT_EAR/lib/*"
#PROJECT_WAR=~/my_project/module-web/target/app-web/WEB-INF
#LIB_PATH="$LIB_PATH:$PROJECT_WAR/lib/*"
#IMPORT_PATH="$PROJECT_WAR/lib/app-*.jar $PROJECT_WAR/classes"

#
# Set application server path and add its libraries to library path (class path).
#
#APP_SERVER=~/sbp-trunk/Environment/jboss/server/sbp_server
#LIB_PATH="$LIB_PATH:$APP_SERVER/modules/*"
#LIB_PATH="$LIB_PATH:$APP_SERVER/lib/*"

#
# Choose java - use JAVA_HOME, if set.
#
if [ "$JAVA_HOME" != "" ]; then
	JAVA="$JAVA_HOME/bin/java"
else
	JAVA="java"
fi

#
# Choose Look and Feel.
#
# modern one - Nimbus
LAF="com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel"
# No explicit settings - java default
# MacOS - java default = system default
if [ `uname` == "Darwin" ]; then
    LAF=""
fi

#
# Final settings.
#
# Look and Feel
if [ "$LAF" != "" ]; then
	OPTS="-Dswing.defaultlaf=$LAF"
fi
# Memory
OPTS="$OPTS -Xmx384m -XX:MaxPermSize=128m"
# GC info
#OPTS="$OPTS -verbose:gc"

#
# Run.
#
CMD="$JAVA $OPTS -cp $LIB_PATH clsvis.gui.ClassVisualizer $IMPORT_PATH $@"
echo "$CMD"
$CMD
