/*
 * Decompiled with CFR 0.152.
 */
package clsvis;

import clsvis.model.ProjectConfig;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ProjectConfigIO {
    public static void save(ProjectConfig projectConfig) {
        try {
            Files.write(projectConfig.path.toPath(), Arrays.asList(ProjectConfig.PersistentFields.classPaths.name() + "=" + String.valueOf(projectConfig.classPaths), ProjectConfig.PersistentFields.importPaths.name() + "=" + String.valueOf(projectConfig.importPaths)), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static ProjectConfig load(File path) {
        ProjectConfig projectConfig;
        block8: {
            Stream<String> fileLines = Files.lines(path.toPath(), StandardCharsets.UTF_8);
            try {
                Map<ProjectConfig.PersistentFields, List> fieldsWithValues = fileLines.map(line -> line.split("[=\\[\\]]+")).collect(Collectors.toMap(vals -> ProjectConfig.PersistentFields.valueOf(vals[0]), vals -> ((String[])vals).length < 2 ? Collections.emptyList() : Arrays.stream(vals[1].split(", ")).filter(fileName -> !fileName.isEmpty()).map(fileName -> new File((String)fileName)).collect(Collectors.toList())));
                projectConfig = new ProjectConfig(path, fieldsWithValues.getOrDefault((Object)ProjectConfig.PersistentFields.classPaths, Collections.emptyList()), fieldsWithValues.getOrDefault((Object)ProjectConfig.PersistentFields.importPaths, Collections.emptyList()));
                if (fileLines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileLines != null) {
                        try {
                            fileLines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            fileLines.close();
        }
        return projectConfig;
    }
}

