/*
 * Decompiled with CFR 0.152.
 */
package clsvis.gui;

import clsvis.gui.StructureBuilder;
import clsvis.gui.graph.GraphComponent;
import clsvis.gui.model.ClassPresentationWrapper;
import clsvis.gui.model.ClassesTableModel;
import clsvis.gui.renderer.ClassesTableCellRenderer;
import clsvis.gui.renderer.CustomTreeCellRenderer;
import clsvis.gui.worker.ClassProcessorTask;
import clsvis.gui.worker.SaveProjectTask;
import clsvis.logging.GUIHandler;
import clsvis.model.Class_;
import clsvis.model.ElementModifier;
import clsvis.model.ProjectConfig;
import clsvis.model.RelationDirection;
import clsvis.model.RelationType;
import clsvis.process.importer.BaseProjectImporter;
import clsvis.process.importer.CompiledClassImporter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MainFrame
extends JFrame {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Object currentClass_;
    private Object viewedClass_;
    private static final boolean ADD_CLASS_TO_HISTORY = true;
    private static final boolean ADD_CLASS_TO_HISTORY_DISABLED = false;
    private ClassesTableModel historyTableModel = new ClassesTableModel();
    private int currentClassHistoryIndex = -1;
    private final ClassesTableRowFilter classesTableRowFilter = new ClassesTableRowFilter();
    private ProjectConfig projectConfig = new ProjectConfig();
    private BaseProjectImporter projectImporter = new BaseProjectImporter();
    private static final boolean MULTI_SELECTION_ENABLED = true;
    private static final boolean MULTI_SELECTION_DISABLED = false;
    private final FileFilter jarFileFilter = new FileNameExtensionFilter("Java Archive (.jar)", "jar");
    private final FileFilter classFileFilter = new FileNameExtensionFilter("Java Class (.class)", "class");
    private final FileFilter projectFileFilter = new FileNameExtensionFilter("Class Visualizer project (.clsvis)", "clsvis");
    private static final Color TREE_SELECTION_BG_COLOR = new Color(8900346);
    private static final int TAB_IDX_CLASS_HIERARCHY = 2;
    private static final int STATUS_CLEANUP_DELAY_MS = 15000;
    private Timer statusCleanupTimer = new Timer(0, null);
    private static final String ABOUT_TITLE = "About";
    private static final String ABOUT_MESSAGE = "<html><center><font size='+2'><b>Class Visualizer</b></font><br><font size='+1'>" + MainFrame.class.getPackage().getSpecificationVersion() + "</font><br><br><table cellpadding=0><tr><td>Build:        <td>" + MainFrame.class.getPackage().getImplementationVersion() + "<tr><td>JVM name:     <td>" + System.getProperty("java.vm.name") + "<tr><td>Java version: <td>" + System.getProperty("java.runtime.version") + "<tr><td>Java home:    <td>" + System.getProperty("java.home") + "</table><br>Author: Jonatan Ka\u017amierczak<br>Jonatan (at) Son-of-God.info<br><br>";
    private JMenuItem aboutMenuItem;
    private JMenuItem addJarsToClasspathMenuItem;
    private JMenu addMenu;
    private JMenuItem backMenuItem;
    private JPanel bottomPanel;
    private JTabbedPane centerTabbedPane;
    private JTable classesTable;
    private JTextField classesTableFilterTextField;
    private JPanel classesTablePanel;
    private JScrollPane classesTableScrollPane;
    private JTree classesTree;
    private JScrollPane classesTreeScrollPane;
    private JScrollPane consoleScrollPane;
    private JTextArea consoleTextArea;
    private JLabel consoleTitle;
    private JMenuItem copyMenuItem;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JPopupMenu.Separator fileMenuSeparator1;
    private JPopupMenu.Separator fileMenuSeparator2;
    private JLabel filterLabel;
    private JPanel filterPanel;
    private JMenuItem forwardMenuItem;
    private JScrollPane graphScrollPane;
    private JMenu helpMenu;
    private JScrollPane historyScrollPane;
    private JTable historyTable;
    private JMenuItem importDirMenuItem;
    private JMenuItem importJarMenuItem;
    private JMenu importMenu;
    private JMenuItem locateClassInHierarchyMenuItem;
    private JPanel mainPanel;
    private JSplitPane mainVerticalSplitPane;
    private JEditorPane membersEditorPane;
    private JScrollPane membersEditorScrollPane;
    private JTree membersTree;
    private JScrollPane membersTreeScrollPane;
    private JMenuBar menuBar;
    private JMenu navigationMenu;
    private JTabbedPane navigationTabbedPane;
    private JMenuItem newProjectMenuItem;
    private JFileChooser openFileChooser;
    private JMenuItem openProjectMenuItem;
    private JProgressBar progressBar;
    private JMenuItem reloadProjectMenuItem;
    private JTabbedPane rightTabbedPane;
    private JMenuItem saveProjectAsMenuItem;
    private JMenuItem saveProjectMenuItem;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JSeparator statusSeparator;
    private JSplitPane topLeftSplitPane;
    private JSplitPane topRightSplitPane;
    private GraphComponent graphComponent;

    public MainFrame() {
        this.preInitComponents();
        this.initComponents();
        this.postInitComponents();
    }

    private void initComponents() {
        this.openFileChooser = new JFileChooser();
        this.mainPanel = new JPanel();
        this.mainVerticalSplitPane = new JSplitPane();
        this.topLeftSplitPane = new JSplitPane();
        this.navigationTabbedPane = new JTabbedPane();
        this.classesTablePanel = new JPanel();
        this.filterPanel = new JPanel();
        this.filterLabel = new JLabel();
        this.classesTableFilterTextField = new JTextField();
        this.classesTableScrollPane = new JScrollPane();
        this.classesTable = new JTable();
        this.membersTreeScrollPane = new JScrollPane();
        this.membersTree = new JTree();
        this.classesTreeScrollPane = new JScrollPane();
        this.classesTree = new JTree();
        this.historyScrollPane = new JScrollPane();
        this.historyTable = new JTable();
        this.topRightSplitPane = new JSplitPane();
        this.centerTabbedPane = new JTabbedPane();
        this.graphScrollPane = new JScrollPane();
        this.rightTabbedPane = new JTabbedPane();
        this.membersEditorScrollPane = new JScrollPane();
        this.membersEditorPane = new JEditorPane();
        this.bottomPanel = new JPanel();
        this.consoleTitle = new JLabel();
        this.consoleScrollPane = new JScrollPane();
        this.consoleTextArea = new JTextArea();
        this.statusPanel = new JPanel();
        this.statusSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newProjectMenuItem = new JMenuItem();
        this.openProjectMenuItem = new JMenuItem();
        this.saveProjectMenuItem = new JMenuItem();
        this.saveProjectAsMenuItem = new JMenuItem();
        this.reloadProjectMenuItem = new JMenuItem();
        this.fileMenuSeparator1 = new JPopupMenu.Separator();
        this.addMenu = new JMenu();
        this.addJarsToClasspathMenuItem = new JMenuItem();
        this.importMenu = new JMenu();
        this.importJarMenuItem = new JMenuItem();
        this.importDirMenuItem = new JMenuItem();
        this.fileMenuSeparator2 = new JPopupMenu.Separator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.copyMenuItem = new JMenuItem();
        this.navigationMenu = new JMenu();
        this.backMenuItem = new JMenuItem();
        this.forwardMenuItem = new JMenuItem();
        this.locateClassInHierarchyMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.openFileChooser.setFileHidingEnabled(false);
        this.setDefaultCloseOperation(3);
        this.setTitle("Class Visualizer");
        this.mainPanel.setLayout(new BorderLayout());
        this.mainVerticalSplitPane.setOrientation(0);
        this.mainVerticalSplitPane.setOneTouchExpandable(true);
        this.topLeftSplitPane.setDividerLocation(320);
        this.topLeftSplitPane.setOneTouchExpandable(true);
        this.classesTablePanel.setLayout(new BorderLayout());
        this.filterPanel.setLayout(new BorderLayout());
        this.filterLabel.setText(" Classes Filter ");
        this.filterPanel.add((Component)this.filterLabel, "Before");
        this.filterPanel.add((Component)this.classesTableFilterTextField, "Center");
        this.classesTablePanel.add((Component)this.filterPanel, "First");
        this.classesTable.setAutoCreateRowSorter(true);
        this.classesTable.setModel(new ClassesTableModel(Collections.emptyList()));
        this.classesTable.setCellSelectionEnabled(true);
        this.classesTableScrollPane.setViewportView(this.classesTable);
        this.classesTablePanel.add((Component)this.classesTableScrollPane, "Center");
        this.navigationTabbedPane.addTab("List", null, this.classesTablePanel, "<html>Select class to see its preview.<br>Double click on class name to navigate into it.<br>Click on header to change sort order.");
        this.membersTree.setCellRenderer(new CustomTreeCellRenderer());
        this.membersTree.setToggleClickCount(0);
        this.membersTreeScrollPane.setViewportView(this.membersTree);
        this.navigationTabbedPane.addTab("Browser", null, this.membersTreeScrollPane, "<html>Select class to see its preview.<br>Double click on class name to navigate into it.<br>Right click on element to see context menu.");
        this.membersTreeScrollPane.getAccessibleContext().setAccessibleName("");
        this.classesTree.setCellRenderer(new CustomTreeCellRenderer());
        this.classesTree.setToggleClickCount(0);
        this.classesTreeScrollPane.setViewportView(this.classesTree);
        this.navigationTabbedPane.addTab("Hierarchy", null, this.classesTreeScrollPane, "<html>Select class to see its preview.<br>Double click on class name to navigate into it.<br>Right click on element to see context menu.");
        this.historyTable.setAutoCreateRowSorter(true);
        this.historyTable.setModel(new ClassesTableModel());
        this.historyTable.setCellSelectionEnabled(true);
        this.historyScrollPane.setViewportView(this.historyTable);
        this.navigationTabbedPane.addTab("History", null, this.historyScrollPane, "<html>Select class to see its preview.<br>Double click on class name to navigate into it.<br>Click on header to change sort order.");
        this.topLeftSplitPane.setLeftComponent(this.navigationTabbedPane);
        this.topRightSplitPane.setOneTouchExpandable(true);
        this.centerTabbedPane.addTab("Relations Diagram", null, this.graphScrollPane, "<html>Click on class name to see its content.<br>Double click on class name to navigate into it.");
        this.topRightSplitPane.setLeftComponent(this.centerTabbedPane);
        this.membersEditorPane.setEditable(false);
        this.membersEditorPane.setContentType("text/html");
        this.membersEditorPane.setDoubleBuffered(true);
        this.membersEditorScrollPane.setViewportView(this.membersEditorPane);
        this.rightTabbedPane.addTab("Preview", null, this.membersEditorScrollPane, "<html>Right click on class to locate it in Hierarchy.<br>Use mouse or press <code>Ctrl+A</code> to select elements.<br>Press <code>Ctrl+C</code> to copy selected text.");
        this.topRightSplitPane.setRightComponent(this.rightTabbedPane);
        this.topLeftSplitPane.setRightComponent(this.topRightSplitPane);
        this.mainVerticalSplitPane.setTopComponent(this.topLeftSplitPane);
        this.bottomPanel.setMinimumSize(new Dimension(0, 0));
        this.bottomPanel.setLayout(new BorderLayout());
        this.consoleTitle.setText(" Log");
        this.bottomPanel.add((Component)this.consoleTitle, "First");
        this.consoleTextArea.setEditable(false);
        this.consoleTextArea.setColumns(5);
        this.consoleTextArea.setRows(5);
        this.consoleScrollPane.setViewportView(this.consoleTextArea);
        this.bottomPanel.add((Component)this.consoleScrollPane, "Center");
        this.mainVerticalSplitPane.setBottomComponent(this.bottomPanel);
        this.mainPanel.add((Component)this.mainVerticalSplitPane, "Center");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.statusPanel.setPreferredSize(new Dimension(400, 30));
        this.statusMessageLabel.setText("_");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusSeparator).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 565, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(this.statusSeparator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.statusMessageLabel).addComponent(this.progressBar, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.statusPanel, "Last");
        this.fileMenu.setMnemonic('f');
        this.fileMenu.setText("File");
        this.newProjectMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        this.newProjectMenuItem.setMnemonic('n');
        this.newProjectMenuItem.setText("New Project");
        this.newProjectMenuItem.setToolTipText("Create new, empty project");
        this.newProjectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.newProjectMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newProjectMenuItem);
        this.openProjectMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.openProjectMenuItem.setMnemonic('o');
        this.openProjectMenuItem.setText("Open Project");
        this.openProjectMenuItem.setToolTipText("Choose project file to be opened");
        this.openProjectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.openProjectMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openProjectMenuItem);
        this.saveProjectMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.saveProjectMenuItem.setMnemonic('s');
        this.saveProjectMenuItem.setText("Save Project");
        this.saveProjectMenuItem.setToolTipText("Save current project");
        this.saveProjectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveProjectMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveProjectMenuItem);
        this.saveProjectAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 192));
        this.saveProjectAsMenuItem.setText("Save Project As ...");
        this.saveProjectAsMenuItem.setToolTipText("Choose location to save current project");
        this.saveProjectAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.saveProjectAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveProjectAsMenuItem);
        this.reloadProjectMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.reloadProjectMenuItem.setMnemonic('r');
        this.reloadProjectMenuItem.setText("Reload Current Project");
        this.reloadProjectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.reloadProjectMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.reloadProjectMenuItem);
        this.fileMenu.add(this.fileMenuSeparator1);
        this.addMenu.setMnemonic('a');
        this.addMenu.setText("Add Required Libraries");
        this.addMenu.setToolTipText("<html>Add libraries required by classes you want to load.<br>You can point to some directory (i.e. Maven repository) and all jar files from all subdirectories will be added.");
        this.addJarsToClasspathMenuItem.setText("directories/JAR files...");
        this.addJarsToClasspathMenuItem.setToolTipText("Choose directories/JARs to add to class path");
        this.addJarsToClasspathMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.addJarsToClasspathMenuItemActionPerformed(evt);
            }
        });
        this.addMenu.add(this.addJarsToClasspathMenuItem);
        this.fileMenu.add(this.addMenu);
        this.importMenu.setMnemonic('l');
        this.importMenu.setText("Load Classes");
        this.importMenu.setToolTipText("Load binary Java classes");
        this.importJarMenuItem.setText("from JAR files...");
        this.importJarMenuItem.setToolTipText("Choose JAR file(s) to load classes from");
        this.importJarMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.importJarMenuItemActionPerformed(evt);
            }
        });
        this.importMenu.add(this.importJarMenuItem);
        this.importDirMenuItem.setText("from directory...");
        this.importDirMenuItem.setToolTipText("Choose class root directory to load classes from");
        this.importDirMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.importDirMenuItemActionPerformed(evt);
            }
        });
        this.importMenu.add(this.importDirMenuItem);
        this.fileMenu.add(this.importMenu);
        this.fileMenu.add(this.fileMenuSeparator2);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.setToolTipText("Exit the application");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setMnemonic('e');
        this.editMenu.setText("Edit");
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.copyMenuItem.setMnemonic('c');
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.setToolTipText("Copies text/diagram into clipboard");
        this.editMenu.add(this.copyMenuItem);
        this.menuBar.add(this.editMenu);
        this.navigationMenu.setMnemonic('n');
        this.navigationMenu.setText("Navigation");
        this.backMenuItem.setAccelerator(KeyStroke.getKeyStroke(37, 512));
        this.backMenuItem.setMnemonic('p');
        this.backMenuItem.setText("Back");
        this.backMenuItem.setToolTipText("Navigate to previous class from History");
        this.backMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.backMenuItemActionPerformed(evt);
            }
        });
        this.navigationMenu.add(this.backMenuItem);
        this.forwardMenuItem.setAccelerator(KeyStroke.getKeyStroke(39, 512));
        this.forwardMenuItem.setMnemonic('n');
        this.forwardMenuItem.setText("Forward");
        this.forwardMenuItem.setToolTipText("Navigate to next class from History");
        this.forwardMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.forwardMenuItemActionPerformed(evt);
            }
        });
        this.navigationMenu.add(this.forwardMenuItem);
        this.locateClassInHierarchyMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        this.locateClassInHierarchyMenuItem.setMnemonic('l');
        this.locateClassInHierarchyMenuItem.setText("Locate Class in Hierarchy");
        this.locateClassInHierarchyMenuItem.setToolTipText("Locate in Hierarchy the class from current Preview");
        this.locateClassInHierarchyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.locateClassInHierarchyMenuItemActionPerformed(evt);
            }
        });
        this.navigationMenu.add(this.locateClassInHierarchyMenuItem);
        this.menuBar.add(this.navigationMenu);
        this.helpMenu.setMnemonic('h');
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setMnemonic('a');
        this.aboutMenuItem.setText(ABOUT_TITLE);
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void saveProjectAsMenuItemActionPerformed(ActionEvent evt) {
        int choice = this.showFileChooser(FileChooserType.SAVE, this.projectFileFilter, FileChooserSelectionMode.FILES, false, "Choose location to save current project");
        if (choice == 0) {
            this.executeWorker(new SaveProjectTask(this, this.openFileChooser.getSelectedFile()));
        }
    }

    private void saveProjectMenuItemActionPerformed(ActionEvent evt) {
        if (this.projectConfig.isPathSet()) {
            this.executeWorker(new SaveProjectTask(this, this.projectConfig.path));
        } else {
            this.saveProjectAsMenuItemActionPerformed(evt);
        }
    }

    private void openProjectMenuItemActionPerformed(ActionEvent evt) {
        int choice = this.showFileChooser(FileChooserType.OPEN, this.projectFileFilter, FileChooserSelectionMode.FILES, false, "Choose project file to be opened");
        if (choice == 0) {
            File selectedFile = this.openFileChooser.getSelectedFile();
            this.resetProject(selectedFile);
            this.executeWorker(new ClassProcessorTask(this, new ProjectConfig(selectedFile)));
        }
    }

    private void newProjectMenuItemActionPerformed(ActionEvent evt) {
        this.resetProject(null);
        this.setTitle("new project");
        String message = "New project created";
        this.setStatusMessage(message);
        this.logger.info(message);
    }

    private void importJarMenuItemActionPerformed(ActionEvent evt) {
        int choice = this.showFileChooser(FileChooserType.OPEN, this.jarFileFilter, FileChooserSelectionMode.FILES, true, "Choose JAR file(s) to load classes from");
        if (choice == 0) {
            this.executeWorker(new ClassProcessorTask(this, new ProjectConfig(this.projectConfig.path, new File[0], this.openFileChooser.getSelectedFiles())));
        }
    }

    private void importDirMenuItemActionPerformed(ActionEvent evt) {
        int choice = this.showFileChooser(FileChooserType.OPEN, this.classFileFilter, FileChooserSelectionMode.DIRECTORIES, false, "Choose class root directory to load classes from");
        if (choice == 0) {
            this.executeWorker(new ClassProcessorTask(this, new ProjectConfig(this.projectConfig.path, new File[0], this.openFileChooser.getSelectedFile())));
        }
    }

    private void addJarsToClasspathMenuItemActionPerformed(ActionEvent evt) {
        int choice = this.showFileChooser(FileChooserType.OPEN, this.jarFileFilter, FileChooserSelectionMode.FILES_AND_DIRECTORIES, true, "Choose directories/JARs to add to class path");
        if (choice == 0) {
            this.executeWorker(new ClassProcessorTask(this, new ProjectConfig(this.projectConfig.path, this.openFileChooser.getSelectedFiles(), new File[0])));
        }
    }

    private void backMenuItemActionPerformed(ActionEvent evt) {
        if (this.currentClassHistoryIndex > 0) {
            --this.currentClassHistoryIndex;
            this.selectClass(this.historyTableModel.getRow(this.currentClassHistoryIndex), false);
        }
    }

    private void forwardMenuItemActionPerformed(ActionEvent evt) {
        if (this.currentClassHistoryIndex < this.historyTableModel.getRowCount() - 1) {
            ++this.currentClassHistoryIndex;
            this.selectClass(this.historyTableModel.getRow(this.currentClassHistoryIndex), false);
        }
    }

    private void locateClassInHierarchyMenuItemActionPerformed(ActionEvent evt) {
        this.navigationTabbedPane.setSelectedIndex(2);
        this.selectClassOnClassesTree(this.viewedClass_);
    }

    private void reloadProjectMenuItemActionPerformed(ActionEvent evt) {
        File projectPath = this.projectConfig.path;
        this.resetProject(projectPath);
        this.executeWorker(new ClassProcessorTask(this, new ProjectConfig(projectPath)));
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, ABOUT_MESSAGE, ABOUT_TITLE, -1);
    }

    private void preInitComponents() {
        UIManager.put("nimbusSelectionBackground", TREE_SELECTION_BG_COLOR);
        UIManager.put("nimbusSelectedText", Color.BLACK);
    }

    private void postInitComponents() {
        this.stopProgress();
        GUIHandler.setTextArea(this.consoleTextArea);
        this.copyMenuItem.setActionCommand((String)TransferHandler.getCopyAction().getValue("Name"));
        this.copyMenuItem.addActionListener(new TransferActionListener());
        this.graphComponent = new GraphComponent();
        this.graphComponent.setToolTipText("");
        this.graphComponent.addMouseListener(new GraphMouseListener());
        this.graphScrollPane.setViewportView(this.graphComponent);
        this.addTableSelectionListener(this.classesTable);
        this.addTableSelectionListener(this.historyTable);
        this.classesTable.addMouseListener(new ClassesTableMouseListener());
        this.historyTable.addMouseListener(new ClassesTableMouseListener());
        this.classesTable.setDefaultRenderer(String.class, new ClassesTableCellRenderer());
        this.historyTable.setDefaultRenderer(String.class, new ClassesTableCellRenderer());
        this.classesTableFilterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MainFrame.this.classesTableRowFilterUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MainFrame.this.classesTableRowFilterUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MainFrame.this.classesTableRowFilterUpdated();
            }
        });
        this.addTreeSelectionListener(this.membersTree);
        this.addTreeSelectionListener(this.classesTree);
        this.membersTree.addMouseListener(new CustomTreeMouseListener());
        this.classesTree.addMouseListener(new CustomTreeMouseListener());
        this.mainVerticalSplitPane.setResizeWeight(1.0);
        this.topRightSplitPane.setResizeWeight(0.7);
        this.setExtendedState(6);
        this.newProjectMenuItemActionPerformed(null);
    }

    private void resetProject(File path) {
        this.projectConfig = new ProjectConfig();
        this.projectConfig.path = path;
        this.projectImporter = new BaseProjectImporter();
        CompiledClassImporter classImporter = this.projectImporter.getClassImporter();
        classImporter.importClass(AccessibleObject.class);
        this.showClasses();
        this.classesTableFilterTextField.setText("");
        this.historyTableModel = new ClassesTableModel();
        this.historyTable.setModel(this.historyTableModel);
        this.currentClassHistoryIndex = -1;
        System.gc();
    }

    public void showClasses() {
        this.getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        CompiledClassImporter classImporter = this.projectImporter.getClassImporter();
        this.classesTable.setModel(new ClassesTableModel(classImporter.getImportedClasses()));
        ClassPresentationWrapper buildClassesTreeNode = StructureBuilder.buildClassesTreeNode2(classImporter.getImportedClassesRoot(), null);
        this.reloadTree(this.classesTree, buildClassesTreeNode);
        this.currentClass_ = null;
        this.viewedClass_ = null;
        this.selectClass(classImporter.getImportedSimpleClass(), false);
        this.getRootPane().setCursor(null);
    }

    void selectClass(Object selectedObject, boolean addToHistory) {
        if (selectedObject == null || !(selectedObject instanceof Class_) || this.currentClass_ == selectedObject) {
            return;
        }
        this.currentClass_ = selectedObject;
        Class_ class_ = (Class_)selectedObject;
        if (addToHistory) {
            ++this.currentClassHistoryIndex;
            this.historyTableModel.addRow(class_, this.currentClassHistoryIndex);
            this.historyTableModel.fireTableDataChanged();
        }
        this.graphComponent.setPreferredSize(this.graphScrollPane.getViewport().getSize());
        this.graphComponent.setMainClass(class_);
        this.reloadTree(this.membersTree, StructureBuilder.buildMembersTreeNode(class_));
        this.membersTree.expandRow(this.membersTree.getRowCount() - 1);
        this.membersTree.expandRow(1);
        this.viewClass(class_);
    }

    void viewClass(Object selectedObject) {
        if (selectedObject == null || !(selectedObject instanceof Class_) || this.viewedClass_ == selectedObject) {
            return;
        }
        this.viewedClass_ = selectedObject;
        this.membersEditorPane.setText(StructureBuilder.buildClassUMLTable((Class_)selectedObject));
        this.membersEditorPane.setCaretPosition(0);
    }

    void classesTableRowFilterUpdated() {
        this.classesTableRowFilter.filter = this.classesTableFilterTextField.getText().toLowerCase();
        ((TableRowSorter)this.classesTable.getRowSorter()).setRowFilter(this.classesTableRowFilter);
    }

    private void addTableSelectionListener(JTable table) {
        table.getSelectionModel().addListSelectionListener(e -> {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int rowIdx = lsm.getLeadSelectionIndex();
            if (rowIdx > -1 && !e.getValueIsAdjusting()) {
                ClassesTableModel model = (ClassesTableModel)table.getModel();
                Class_ class_ = model.getRow(table.convertRowIndexToModel(rowIdx));
                this.viewClass(class_);
            }
        });
    }

    private void reloadTree(JTree tree, TreeNode rootNode) {
        tree.setModel(new DefaultTreeModel(rootNode));
    }

    private void addTreeSelectionListener(JTree tree) {
        tree.addTreeSelectionListener((TreeSelectionEvent e) -> {
            TreePath treePath = e.getNewLeadSelectionPath();
            if (treePath != null) {
                TreeNode clickedNode = (TreeNode)treePath.getLastPathComponent();
                Object userObject = clickedNode instanceof ClassPresentationWrapper ? ((ClassPresentationWrapper)clickedNode).class_ : ((DefaultMutableTreeNode)clickedNode).getUserObject();
                this.viewClass(userObject);
            }
        });
    }

    void selectClassOnClassesTree(Object userObject) {
        ClassPresentationWrapper prevNode;
        Class_ class_ = (Class_)userObject;
        if (class_.modifiers.contains((Object)ElementModifier.Interface)) {
            return;
        }
        ArrayList<Class_> classPath = new ArrayList<Class_>();
        while (true) {
            classPath.add(class_);
            if (class_.relationsMap.get((Object)RelationDirection.Outbound).get((Object)RelationType.SuperClass).isEmpty()) break;
            class_ = class_.relationsMap.get((Object)RelationDirection.Outbound).get((Object)RelationType.SuperClass).iterator().next();
        }
        Collections.reverse(classPath);
        Object[] path = new ClassPresentationWrapper[classPath.size()];
        TreeModel treeModel = this.classesTree.getModel();
        path[0] = prevNode = (ClassPresentationWrapper)treeModel.getRoot();
        for (int i = 1; i < path.length; ++i) {
            ClassPresentationWrapper currNode = new ClassPresentationWrapper((Class_)classPath.get(i), null);
            currNode = (ClassPresentationWrapper)prevNode.getChildAt(prevNode.getIndex(currNode));
            path[i] = currNode;
            prevNode = currNode;
        }
        TreePath treePath = new TreePath(path);
        this.classesTree.setSelectionPath(treePath);
        this.classesTree.scrollPathToVisible(treePath);
    }

    private void executeWorker(SwingWorker<?, ?> worker) {
        worker.execute();
    }

    private int showFileChooser(FileChooserType dialogType, FileFilter fileFilter, FileChooserSelectionMode selectionMode, boolean multiSelectionEnabled, String title) {
        this.openFileChooser.setDialogType(dialogType.ordinal());
        this.openFileChooser.setDialogTitle(title);
        this.openFileChooser.resetChoosableFileFilters();
        this.openFileChooser.setFileFilter(fileFilter);
        this.openFileChooser.setFileSelectionMode(selectionMode.ordinal());
        this.openFileChooser.setMultiSelectionEnabled(multiSelectionEnabled);
        this.openFileChooser.setSelectedFile(null);
        this.openFileChooser.setSelectedFiles(null);
        return this.openFileChooser.showDialog(this, null);
    }

    public void startProgress() {
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(true);
    }

    public void moveProgress(int percent) {
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(percent);
    }

    public void stopProgress() {
        this.progressBar.setVisible(false);
        this.progressBar.setValue(0);
        this.statusCleanupTimer.stop();
        this.statusCleanupTimer = new Timer(15000, e -> this.setStatusMessage(""));
        this.statusCleanupTimer.start();
    }

    public void setStatusMessage(String message) {
        this.statusMessageLabel.setText(message);
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title + " - Class Visualizer");
    }

    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    public BaseProjectImporter getProjectImporter() {
        return this.projectImporter;
    }

    private static class ClassesTableRowFilter
    extends RowFilter<ClassesTableModel, Integer> {
        private String filter = "";

        private ClassesTableRowFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends ClassesTableModel, ? extends Integer> entry) {
            return entry.getModel().getRow((int)entry.getIdentifier().intValue()).fullTypeName.toLowerCase().contains(this.filter);
        }
    }

    private static enum FileChooserType {
        OPEN,
        SAVE;

    }

    private static enum FileChooserSelectionMode {
        FILES,
        DIRECTORIES,
        FILES_AND_DIRECTORIES;

    }

    static class TransferActionListener
    implements ActionListener,
    PropertyChangeListener {
        private JComponent focusOwner;

        public TransferActionListener() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", this);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.focusOwner != null) {
                String actionCommand = evt.getActionCommand();
                Action action = this.focusOwner.getActionMap().get(actionCommand);
                if (action != null) {
                    action.actionPerformed(new ActionEvent(this.focusOwner, 1001, null));
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue = evt.getNewValue();
            this.focusOwner = newValue instanceof JComponent ? (JComponent)newValue : null;
        }
    }

    private class GraphMouseListener
    extends MouseAdapter {
        private GraphMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            MainFrame.this.graphComponent.requestFocusInWindow();
            int clickCount = evt.getClickCount();
            Class_ clickedObject = MainFrame.this.graphComponent.selectVertexAt(evt.getX(), evt.getY());
            if (clickCount == 2) {
                MainFrame.this.selectClass(clickedObject, true);
            } else if (clickCount == 1) {
                MainFrame.this.viewClass(clickedObject);
            }
        }
    }

    private class ClassesTableMouseListener
    extends MouseAdapter {
        private ClassesTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            JTable table = (JTable)evt.getSource();
            int rowIdx = table.rowAtPoint(new Point(evt.getX(), evt.getY()));
            if (rowIdx > -1) {
                ClassesTableModel model = (ClassesTableModel)table.getModel();
                Class_ clickedObject = model.getRow(table.convertRowIndexToModel(rowIdx));
                if (evt.getClickCount() == 2) {
                    MainFrame.this.selectClass(clickedObject, true);
                }
            }
        }
    }

    private class CustomTreeMouseListener
    extends MouseAdapter {
        private CustomTreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath treePath = ((JTree)e.getSource()).getPathForLocation(e.getX(), e.getY());
            if (treePath != null) {
                Object userObject;
                TreeNode clickedNode = (TreeNode)treePath.getLastPathComponent();
                Object object = userObject = clickedNode instanceof ClassPresentationWrapper ? ((ClassPresentationWrapper)clickedNode).class_ : ((DefaultMutableTreeNode)clickedNode).getUserObject();
                if (e.getClickCount() == 2) {
                    MainFrame.this.selectClass(userObject, true);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class ClassesTableSelectionListener
    implements ListSelectionListener {
        private final JTable table;

        public ClassesTableSelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int rowIdx = lsm.getLeadSelectionIndex();
            if (rowIdx > -1 && !e.getValueIsAdjusting()) {
                ClassesTableModel model = (ClassesTableModel)this.table.getModel();
                Class_ class_ = model.getRow(this.table.convertRowIndexToModel(rowIdx));
                MainFrame.this.viewClass(class_);
            }
        }
    }
}

