/*
 * Decompiled with CFR 0.152.
 */
package clsvis.gui.worker;

import clsvis.Utils;
import clsvis.gui.MainFrame;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

public abstract class BaseTask<T, V>
extends SwingWorker<T, V> {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected final MainFrame mainFrame;

    public BaseTask(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.addPropertyChangeListener();
    }

    private void addPropertyChangeListener() {
        this.addPropertyChangeListener(event -> {
            switch (event.getPropertyName()) {
                case "state": {
                    this.onStateChange((SwingWorker.StateValue)((Object)((Object)event.getNewValue())));
                    break;
                }
                case "progress": {
                    this.onProgressGuiUpdate((Integer)event.getNewValue());
                }
            }
        });
    }

    private void onStateChange(SwingWorker.StateValue state) {
        switch (state) {
            case STARTED: {
                this.beforeStartedGuiUpdate();
                break;
            }
            case DONE: {
                this.afterDoneGuiUpdate();
            }
        }
    }

    protected void beforeStartedGuiUpdate() {
        this.mainFrame.startProgress();
    }

    protected void onProgressGuiUpdate(int progressPercent) {
        this.mainFrame.moveProgress(progressPercent);
    }

    protected void afterDoneGuiUpdate() {
    }

    @Override
    protected void done() {
        try {
            this.onSuccessGuiUpdate(this.get());
        }
        catch (InterruptedException | ExecutionException e) {
            this.onFailureGuiUpdate(e);
        }
        finally {
            this.mainFrame.stopProgress();
        }
    }

    protected void onSuccessGuiUpdate(T result) {
    }

    protected void onFailureGuiUpdate(Exception cause) {
        this.logSevere(Utils.rootCauseAsString(cause));
        this.logger.throwing("", "", cause);
    }

    protected void log(Level level, String message) {
        this.mainFrame.setStatusMessage(message);
        this.logger.log(level, message);
    }

    protected void logInfo(String message) {
        this.log(Level.INFO, message);
    }

    protected void logWarning(String message) {
        this.log(Level.WARNING, message);
    }

    protected void logSevere(String message) {
        this.log(Level.SEVERE, message);
    }
}

