/*
 * Decompiled with CFR 0.152.
 */
package clsvis.gui.worker;

import clsvis.ProjectConfigIO;
import clsvis.Utils;
import clsvis.gui.MainFrame;
import clsvis.gui.worker.BaseTask;
import clsvis.model.ProjectConfig;
import java.io.File;

public class SaveProjectTask
extends BaseTask<Void, Void> {
    private final ProjectConfig projectConfig;

    public SaveProjectTask(MainFrame mainFrame) {
        super(mainFrame);
        this.projectConfig = mainFrame.getProjectConfig();
    }

    public SaveProjectTask(MainFrame mainFrame, File path) {
        this(mainFrame);
        this.projectConfig.path = path.getName().endsWith("clsvis") ? path : new File(path.getAbsolutePath() + ".clsvis");
    }

    @Override
    protected Void doInBackground() {
        this.logInfo("Saving project: " + String.valueOf(this.projectConfig.path));
        ProjectConfigIO.save(this.projectConfig);
        return null;
    }

    @Override
    protected void onSuccessGuiUpdate(Void result) {
        this.logInfo("Project saved successfully: " + String.valueOf(this.projectConfig.path));
        this.mainFrame.setTitle(this.projectConfig.path.toString());
        super.onSuccessGuiUpdate(result);
    }

    @Override
    protected void onFailureGuiUpdate(Exception cause) {
        this.logSevere("Project saving failed: " + Utils.rootCauseAsString(cause));
        this.logger.throwing("", "", cause);
        this.projectConfig.path = null;
    }
}

