/*
 * Decompiled with CFR 0.152.
 */
package clsvis.model;

import clsvis.gui.ColorContext;
import clsvis.model.ElementKind;
import clsvis.model.ElementModifier;
import clsvis.model.ElementVisibility;
import clsvis.model.ParameterizableElement;
import clsvis.model.RelationDirection;
import clsvis.model.RelationType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Class_
extends ParameterizableElement {
    private static final Set<RelationType> CHECKABLE_RELATIONS = EnumSet.of(RelationType.InnerClass, RelationType.Association, RelationType.Dependency);
    private static final Set<RelationType> IMMUTABLE_RELATIONS = EnumSet.of(RelationType.SuperClass, RelationType.SuperInterface, RelationType.InnerClass);
    private static final Set<ElementKind> MEMBER_KINDS_EXTENDED = EnumSet.of(ElementKind.Constants, new ElementKind[]{ElementKind.Fields, ElementKind.Properties, ElementKind.Constructors, ElementKind.Methods, ElementKind.Extends, ElementKind.Implements});
    private final String typeParametersStr;
    public final Map<ElementKind, List<ParameterizableElement>> membersMap = new EnumMap<ElementKind, List<ParameterizableElement>>(ElementKind.class);
    public final Map<RelationDirection, Map<RelationType, Collection<Class_>>> relationsMap = new EnumMap<RelationDirection, Map<RelationType, Collection<Class_>>>(RelationDirection.class);
    public final Map<RelationDirection, Collection<Class_>> relationsToCheck = new EnumMap<RelationDirection, Collection<Class_>>(RelationDirection.class);
    public boolean relationsProcessed;

    public Class_(String id, String name, Class clazz, Collection<ElementModifier> modifiers, ElementKind kind, ElementVisibility visibility) {
        super(id, name, clazz, clazz, modifiers, kind, visibility);
        TypeVariable<Class<T>>[] typeParams = clazz.getTypeParameters();
        if (typeParams.length > 0) {
            StringBuilder sb = new StringBuilder(256);
            sb.append("&lt;");
            TypeVariable<Class<T>>[] typeVariableArray = typeParams;
            int n = typeVariableArray.length;
            for (int i = 0; i < n; ++i) {
                String varType;
                TypeVariable tvar = typeVariableArray[i];
                sb.append(tvar);
                Type varBound = tvar.getBounds()[0];
                String string = varType = varBound instanceof Class ? ((Class)varBound).getName() : varBound.toString();
                if (!varBound.equals(Object.class)) {
                    sb.append(" extends ").append(varType);
                }
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append('>');
            this.typeParametersStr = sb.toString();
        } else {
            this.typeParametersStr = "";
        }
        for (RelationDirection relationDirection : RelationDirection.values()) {
            EnumMap relationsSideMap = new EnumMap(RelationType.class);
            for (RelationType relationType : RelationType.values()) {
                relationsSideMap.put(relationType, new TreeSet());
            }
            this.relationsMap.put(relationDirection, relationsSideMap);
            this.relationsToCheck.put(relationDirection, new HashSet());
        }
    }

    public void addMember(ParameterizableElement element) {
        ElementKind memberKind = element.kind;
        List<ParameterizableElement> members = this.membersMap.get((Object)memberKind);
        if (members == null) {
            members = new LinkedList<ParameterizableElement>();
            this.membersMap.put(memberKind, members);
        }
        members.add(element);
    }

    public Collection<ParameterizableElement> getMembers(ElementKind elementKind) {
        return this.membersMap.get((Object)elementKind);
    }

    public void addRelation(RelationType relType, Class_ class_) {
        if (class_ != this) {
            this.addRelation(relType, class_, RelationDirection.Outbound);
            class_.addRelation(relType, this, RelationDirection.Inbound);
        }
    }

    public void addSuperInterface(Class_ class_) {
        this.addRelation(RelationType.SuperInterface, class_, RelationDirection.Outbound);
        class_.addRelation(this.modifiers.contains((Object)ElementModifier.Interface) ? RelationType.SuperInterface : RelationType.SuperClass, this, RelationDirection.Inbound);
    }

    private void addRelation(RelationType relType, Class_ class_, RelationDirection relDirection) {
        if (CHECKABLE_RELATIONS.contains((Object)relType) && !this.relationsToCheck.get((Object)relDirection).add(class_)) {
            return;
        }
        this.relationsMap.get((Object)relDirection).get((Object)relType).add(class_);
    }

    public Collection<Class_> getRelations(RelationType relType, RelationDirection relDirection) {
        return this.relationsMap.get((Object)relDirection).get((Object)relType);
    }

    public void membersFinished() {
        for (ElementKind elementKind : MEMBER_KINDS_EXTENDED) {
            List<ParameterizableElement> memberList = this.membersMap.get((Object)elementKind);
            if (memberList != null) {
                Collections.sort(memberList);
                continue;
            }
            this.membersMap.put(elementKind, Collections.EMPTY_LIST);
        }
        for (RelationType relType : IMMUTABLE_RELATIONS) {
            Collection<Class_> classesSet;
            this.relationsMap.get((Object)RelationDirection.Outbound).put(relType, (Collection<Class_>)((classesSet = this.relationsMap.get((Object)RelationDirection.Outbound).get((Object)relType)).isEmpty() ? Collections.EMPTY_LIST : new ArrayList<Class_>(classesSet)));
        }
    }

    public void relationsFinished() {
        Collection<Class_> outerClassesSet;
        this.relationsProcessed = true;
        this.relationsMap.get((Object)RelationDirection.Inbound).put(RelationType.InnerClass, (Collection<Class_>)((outerClassesSet = this.relationsMap.get((Object)RelationDirection.Inbound).get((Object)RelationType.InnerClass)).isEmpty() ? Collections.EMPTY_LIST : new ArrayList<Class_>(outerClassesSet)));
        for (RelationType relType : RelationType.values()) {
            if (!this.relationsMap.get((Object)RelationDirection.Outbound).get((Object)relType).isEmpty()) continue;
            this.relationsMap.get((Object)RelationDirection.Outbound).put(relType, Collections.EMPTY_LIST);
        }
    }

    public String getNamespaceUml() {
        String nameSpace = this.getFullNameUml();
        int namespaceBreakIdx = nameSpace.lastIndexOf("::");
        return namespaceBreakIdx < 0 ? null : nameSpace.substring(0, namespaceBreakIdx + 2);
    }

    public String getFullNameUml() {
        return this.fullTypeName.replaceAll("\\.", "::");
    }

    public String getShortNameWithParams() {
        return this.getWithParams(this.name).replaceAll("\\w+[\\.\\$](?!\\d+)", "");
    }

    public String getFullNameWithParams() {
        return this.getWithParams(this.id);
    }

    private String getWithParams(String prefix) {
        return this.typeParametersStr.length() == 0 ? prefix : prefix + this.typeParametersStr;
    }

    @Override
    public String toString() {
        return this.toStringWithTypeParameters();
    }

    public String toStringWithTypeParameters() {
        return this.toStringWithNames(this.getShortNameWithParams().replace("<", "&lt;"), this.getWithParams(this.id).replace("<", "&lt;"));
    }

    private String toStringWithNames(String nameParam, String fullNameParam) {
        return String.format("<html><table cellspacing=0 cellpadding=0><tr><td style=\"border-style: solid; border-width: 1; border-color: black;\">%s<td><span %s>&nbsp;%s%s%s <b>%s</b>%s%s</span> (%s) %s</table>", this.kind.symbolStr, this.relationsProcessed ? "" : "color=#" + ColorContext.ClassUnprocessed.colorStr, this.isStatic() ? "<u>" : "", this.isAbstract() ? "<i>" : "", this.visibility.symbolStr, nameParam, this.isAbstract() ? "</i>" : "", this.isStatic() ? "</u>" : "", fullNameParam, this.getStereotypesAsString(" ", false));
    }
}

