/*
 * Decompiled with CFR 0.152.
 */
package clsvis.model;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;

public final class ProjectConfig {
    public File path;
    public Collection<File> classPaths = new LinkedHashSet<File>();
    public Collection<File> importPaths = new LinkedHashSet<File>();

    public ProjectConfig() {
    }

    public ProjectConfig(File path) {
        this.path = path;
    }

    public ProjectConfig(File path, Collection<File> classPaths, Collection<File> importPaths) {
        this.path = path;
        this.classPaths.addAll(classPaths);
        this.importPaths.addAll(importPaths);
    }

    public ProjectConfig(File path, File[] classPaths, File ... importPaths) {
        this(path, Arrays.asList(classPaths), Arrays.asList(importPaths));
    }

    public void setContent(File path, ProjectConfig config) {
        this.path = path;
        this.classPaths = config.classPaths;
        this.importPaths = config.importPaths;
    }

    public void addContent(ProjectConfig config) {
        this.classPaths.addAll(config.classPaths);
        this.importPaths.addAll(config.importPaths);
    }

    public boolean isPathSet() {
        return this.path != null;
    }

    public boolean isPathToBeUsedForProjectLoad() {
        return this.path != null && this.classPaths.isEmpty() && this.importPaths.isEmpty();
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + Objects.hashCode(this.path);
        hash = 17 * hash + Objects.hashCode(this.classPaths);
        hash = 17 * hash + Objects.hashCode(this.importPaths);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectConfig other = (ProjectConfig)obj;
        if (!Objects.equals(this.path, other.path)) {
            return false;
        }
        if (!Objects.equals(this.classPaths, other.classPaths)) {
            return false;
        }
        return Objects.equals(this.importPaths, other.importPaths);
    }

    public String toString() {
        return "ProjectConfig{path=" + String.valueOf(this.path) + ", classPaths=" + String.valueOf(this.classPaths) + ", importPaths=" + String.valueOf(this.importPaths) + "}";
    }

    public static enum PersistentFields {
        classPaths,
        importPaths;

    }
}

