/*
 * Decompiled with CFR 0.152.
 */
package clsvis.process.importer;

import clsvis.process.importer.CompiledClassImporter;
import clsvis.process.importer.ImportException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BaseProjectImporter {
    private static final Logger logger = Logger.getLogger(BaseProjectImporter.class.getName());
    public static final String jarFileName = ".jar";
    private static final String classFileSuffix = ".class";
    protected final CompiledClassImporter classImporter = new CompiledClassImporter();
    protected Collection<File> classPaths = new LinkedHashSet<File>();
    protected final List<String> classNames = new ArrayList<String>(16384);

    public void importProject(Collection<File> paths) {
        this.classNames.clear();
        try {
            this.findClassNames(paths);
            logger.log(Level.CONFIG, "Project size: {0} top-level classes", this.classNames.size());
            if (!this.classNames.isEmpty()) {
                Collection<File> originalClassPaths = this.classPaths;
                this.classPaths = new LinkedHashSet<File>(((originalClassPaths.size() + paths.size()) * 4 + 2) / 3);
                this.classPaths.addAll(paths);
                this.classPaths.addAll(originalClassPaths);
                this.initClassLoader();
                this.runClassesImport();
            }
        }
        catch (IOException e) {
            BaseProjectImporter.logThrowable(e);
            throw new ImportException(e);
        }
        catch (ImportException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            BaseProjectImporter.logThrowable(e);
            throw e;
        }
    }

    public void cleanupAfterImport() {
        try {
            URLClassLoader classLoader = this.classImporter.getClassLoader();
            if (classLoader != null) {
                classLoader.close();
            }
        }
        catch (IOException e) {
            BaseProjectImporter.logThrowable(e);
        }
        this.classImporter.setClassLoader(null);
        this.classImporter.setImportProgressListener(null);
        this.classNames.clear();
    }

    private void findClassNamesInDirectory(File classesDir, Collection<String> subDirNames) {
        File currPath = classesDir;
        for (String string : subDirNames) {
            currPath = new File(currPath, string);
        }
        String currPathName = currPath.getPath();
        if (currPathName.startsWith(".")) {
            return;
        }
        if (currPath.isDirectory()) {
            for (String dirEntryName : currPath.list()) {
                ArrayList<String> newSubDirNames = new ArrayList<String>(subDirNames);
                newSubDirNames.add(dirEntryName);
                this.findClassNamesInDirectory(classesDir, newSubDirNames);
            }
        } else if (BaseProjectImporter.isTopLevelClass(currPathName)) {
            StringBuilder stringBuilder = new StringBuilder(128);
            for (String subDirName : subDirNames) {
                stringBuilder.append(subDirName).append('.');
            }
            stringBuilder.setLength(stringBuilder.length() - 7);
            this.classNames.add(stringBuilder.toString());
        }
    }

    private void findClassNamesInJarFile(File jarFile) throws IOException {
        try (ZipFile zipFile = new ZipFile(jarFile);){
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                String entryName = zipEntries.nextElement().getName();
                if (!BaseProjectImporter.isTopLevelClass(entryName)) continue;
                this.classNames.add(entryName.replace('/', '.').substring(0, entryName.length() - 6));
            }
        }
    }

    protected void findClassNames(Collection<File> paths) throws IOException {
        for (File path : paths) {
            this.findClassNames(path);
        }
    }

    protected void findClassNames(File path) throws IOException {
        if (path == null) {
            throw new IOException("No path available");
        }
        BaseProjectImporter.checkPathExists(path);
        if (path.isDirectory()) {
            this.findClassNamesInDirectory(path, Collections.EMPTY_LIST);
        } else if (path.getName().endsWith(jarFileName)) {
            this.findClassNamesInJarFile(path);
        } else {
            throw new IOException(String.format("Unsupported type of path '%s'", path.getName()));
        }
    }

    private static boolean isTopLevelClass(String entry) {
        return entry.endsWith(classFileSuffix) && !entry.contains("$");
    }

    public void addClassPaths(Collection<File> paths) {
        for (File path : paths) {
            this.findJarsInDirectory(path);
        }
    }

    private void findJarsInDirectory(File currPath) {
        block5: {
            String currPathName;
            block4: {
                currPathName = currPath.getPath();
                if (currPathName.startsWith(".")) {
                    return;
                }
                if (!currPath.isDirectory()) break block4;
                File[] dirEntries = currPath.listFiles();
                Arrays.sort(dirEntries, Collections.reverseOrder());
                for (File dirEntry : dirEntries) {
                    this.findJarsInDirectory(dirEntry);
                }
                break block5;
            }
            if (!currPathName.endsWith(jarFileName)) break block5;
            try {
                logger.log(Level.FINEST, "Adding to class path: {0}", currPath);
                BaseProjectImporter.checkPathExists(currPath);
                this.classPaths.add(currPath);
            }
            catch (FileNotFoundException ex) {
                logger.log(Level.WARNING, "Problem during adding element to class path: {0}", ex.toString());
                BaseProjectImporter.logThrowable(ex);
            }
        }
    }

    protected void initClassLoader() {
        ArrayList<URL> classpathURLs = new ArrayList<URL>(this.classPaths.size());
        for (File classPath : this.classPaths) {
            try {
                if (!classPath.exists()) {
                    logger.warning(String.format("Classpath entry '%s' doesn't exist", classPath.getPath()));
                }
                classpathURLs.add(classPath.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                logger.log(Level.WARNING, String.format("Problem during processing classpath entry '%s':", classPath.getPath()), ex);
            }
        }
        URLClassLoader classLoader = new URLClassLoader(classpathURLs.toArray(new URL[classpathURLs.size()]));
        this.classImporter.setClassLoader(classLoader);
    }

    protected void runClassesImport() {
        this.classImporter.importClasses(this.classNames);
    }

    protected static void checkPathExists(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getPath());
        }
    }

    protected static void logThrowable(Throwable t) {
        logger.throwing("", "", t);
    }

    public CompiledClassImporter getClassImporter() {
        return this.classImporter;
    }

    public Collection<String> getClassNames() {
        return this.classNames;
    }

    public Collection<File> getClassPaths() {
        return this.classPaths;
    }
}

