/*
 * Decompiled with CFR 0.152.
 */
package clsvis.process.importer;

import clsvis.Utils;
import clsvis.model.Annotation_;
import clsvis.model.Class_;
import clsvis.model.ElementKind;
import clsvis.model.ElementModifier;
import clsvis.model.ElementVisibility;
import clsvis.model.Operation;
import clsvis.model.ParameterizableElement;
import clsvis.model.RelationDirection;
import clsvis.model.RelationType;
import clsvis.process.importer.ImportException;
import clsvis.process.importer.ImportProgressListener;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompiledClassImporter {
    private static final Logger logger = Logger.getLogger(CompiledClassImporter.class.getName());
    private static final Set<ElementModifier> generalModifiers = Collections.unmodifiableSet(EnumSet.of(ElementModifier.Public, new ElementModifier[]{ElementModifier.Protected, ElementModifier.Private, ElementModifier.Abstract, ElementModifier.Static, ElementModifier.Final, ElementModifier.Transient, ElementModifier.Volatile, ElementModifier.Synchronized, ElementModifier.Native, ElementModifier.Strict}));
    private static final Set<ElementModifier> constantModifiers = Collections.unmodifiableSet(EnumSet.of(ElementModifier.Static, ElementModifier.Final));
    private static final Set<ElementModifier> classModifiers = Collections.unmodifiableSet(EnumSet.of(ElementModifier.Interface, new ElementModifier[]{ElementModifier.Enum, ElementModifier.Annotation, ElementModifier.Record, ElementModifier.Sealed, ElementModifier.LocalClass, ElementModifier.MemberClass, ElementModifier.Synthetic}));
    public static final Set<ElementModifier> fieldModifiers = Collections.unmodifiableSet(EnumSet.of(ElementModifier.Synthetic));
    public static final Set<ElementModifier> constructorModifiers = Collections.unmodifiableSet(EnumSet.of(ElementModifier.Synthetic));
    private static final Set<ElementModifier> methodModifiers = Collections.unmodifiableSet(EnumSet.of(ElementModifier.Synthetic, ElementModifier.Bridge, ElementModifier.Default));
    public static final Set<ElementModifier> parameterModifiers = Collections.unmodifiableSet(EnumSet.of(ElementModifier.Implicit, ElementModifier.Synthetic, ElementModifier.VarArgs));
    private static final EnumMap<ElementKind, RelationType> memberKindRelations = new EnumMap(ElementKind.class);
    private final Map<ElementModifier, Method> generalModifierProcessors = new EnumMap<ElementModifier, Method>(ElementModifier.class);
    private final Map<String, Map<ElementModifier, Method>> elementModifierProcessors = new HashMap<String, Map<ElementModifier, Method>>(5, 1.0f);
    private final Map<String, Class_> importedClasses = new HashMap<String, Class_>();
    private final Collection<String> notImportedClassNames = new HashSet<String>();
    private URLClassLoader classLoader;
    private ImportProgressListener importProgressListener;
    private static final Pattern getterPattern;

    public CompiledClassImporter() {
        for (ElementModifier em : generalModifiers) {
            this.generalModifierProcessors.put(em, CompiledClassImporter.createMemberMethod(em.name(), Modifier.class, Integer.TYPE));
        }
        this.initModifierProcessors(classModifiers, Class.class);
        this.initModifierProcessors(fieldModifiers, Field.class);
        this.initModifierProcessors(constructorModifiers, Constructor.class);
        this.initModifierProcessors(methodModifiers, Method.class);
        this.initModifierProcessors(parameterModifiers, Parameter.class);
    }

    private void initModifierProcessors(Collection<ElementModifier> elementModifiers, Class clazz) {
        EnumMap<ElementModifier, Method> modifierProcessors = new EnumMap<ElementModifier, Method>(ElementModifier.class);
        this.elementModifierProcessors.put(clazz.getName(), modifierProcessors);
        for (ElementModifier em : elementModifiers) {
            try {
                modifierProcessors.put(em, CompiledClassImporter.createMemberMethod(em.name(), clazz, new Class[0]));
            }
            catch (UnsupportedOperationException e) {
                logger.log(Level.FINE, () -> "Non-existing flag: " + Utils.rootCauseAsString(e));
                logger.log(Level.FINER, "", e);
            }
        }
    }

    private static Method createMemberMethod(String suffix, Class memberClass, Class ... paramTypes) {
        try {
            return memberClass.getMethod("is" + suffix, paramTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public void importClasses(Collection<String> classNames) {
        int totalCount = classNames.size();
        int importedCount = 0;
        this.notImportedClassNames.clear();
        for (String className : classNames) {
            this.importClass(className);
            if (this.importProgressListener == null) continue;
            this.importProgressListener.importProgress(++importedCount, totalCount);
        }
    }

    public void importClass(String className) {
        try {
            Class<?> clazz = Class.forName(className, false, this.classLoader);
            this.importClass(clazz);
        }
        catch (ClassNotFoundException e) {
            this.processThrowable(Level.SEVERE, e, className);
            throw new ImportException(e);
        }
        catch (LinkageError e) {
            this.processThrowable(Level.WARNING, e, className);
            this.notImportedClassNames.add(className);
        }
        catch (RuntimeException e) {
            this.processThrowable(Level.WARNING, e, className);
            this.notImportedClassNames.add(className);
        }
        catch (Error e) {
            if (e instanceof OutOfMemoryError) {
                this.importedClasses.clear();
                this.notImportedClassNames.clear();
                this.processThrowable(Level.SEVERE, e, className);
                System.exit(1);
            }
            this.processThrowable(Level.SEVERE, e, className);
            throw e;
        }
    }

    public Class_ importClass(Class clazz) {
        Class_ class_ = this.importClassInternal(clazz);
        for (Map.Entry<ElementKind, RelationType> memberKindRelation : memberKindRelations.entrySet()) {
            this.addRelations(class_, class_.getMembers(memberKindRelation.getKey()), memberKindRelation.getValue());
        }
        this.addRelations(class_, Arrays.asList(class_), RelationType.Dependency);
        for (Class_ innerClass : class_.getRelations(RelationType.InnerClass, RelationDirection.Outbound)) {
            this.importClass(innerClass.originalTypeName);
        }
        class_.relationsFinished();
        return class_;
    }

    private Class_ importClassInternal(String className) {
        if (className == null) {
            return null;
        }
        Class_ cached = this.importedClasses.get(className);
        if (cached != null) {
            return cached;
        }
        try {
            Class<?> clazz = Class.forName(className, false, this.classLoader);
            return this.importClassInternal(clazz);
        }
        catch (ClassNotFoundException e) {
            this.processThrowable(Level.SEVERE, e, className);
            throw new ImportException(e);
        }
    }

    public Class_ importClassInternal(Class clazz) {
        if ((clazz = Utils.getClassType(clazz)) == null) {
            return null;
        }
        String className = clazz.getName();
        Class_ cached = this.importedClasses.get(className);
        if (cached != null) {
            return cached;
        }
        try {
            return this.importClassInternal0(clazz);
        }
        catch (Error | RuntimeException e) {
            this.importedClasses.remove(className);
            throw e;
        }
    }

    private Class_ importClassInternal0(Class clazz) {
        LinkedHashSet<Field> declaredFields = new LinkedHashSet<Field>(Arrays.asList(clazz.getDeclaredFields()));
        List<Method> declaredMethods = Arrays.asList(clazz.getDeclaredMethods());
        Collection<ElementModifier> classModifiers = this.decodeModifiers(clazz.getModifiers(), clazz);
        String classCanonicalName = clazz.getCanonicalName();
        Class_ class_ = new Class_(classCanonicalName != null ? classCanonicalName : clazz.getName(), clazz.getSimpleName(), clazz, classModifiers, CompiledClassImporter.getKind(classModifiers, clazz), CompiledClassImporter.getVisibility(classModifiers));
        this.importedClasses.put(clazz.getName(), class_);
        Class superClass = clazz.getSuperclass();
        Type superGenericType = clazz.getGenericSuperclass();
        Class_ superClass_ = this.importClassInternal(superClass);
        if (superClass_ != null) {
            class_.addRelation(RelationType.SuperClass, superClass_);
            class_.addMember(new ParameterizableElement("extends", "extends", superClass, superGenericType, Collections.EMPTY_LIST, ElementKind.Extends, ElementVisibility.Local));
        }
        for (TypeVariable paramType : clazz.getTypeParameters()) {
            CompiledClassImporter.importTypeParameters(paramType, clazz, class_.typeParameters);
        }
        CompiledClassImporter.importTypeParameters(superGenericType, superClass, class_.typeParameters);
        Class[] superInterfaces = clazz.getInterfaces();
        Type[] superGenericInterfaces = CompiledClassImporter.getCorrectedGenericTypes(clazz.getGenericInterfaces(), superInterfaces, class_.id, true);
        for (int i = 0; i < superGenericInterfaces.length; ++i) {
            class_.addMember(new ParameterizableElement("implements" + (i + 1), "implements" + (i + 1), superInterfaces[i], superGenericInterfaces[i], Collections.EMPTY_LIST, ElementKind.Implements, ElementVisibility.Local));
        }
        for (Class usedSuperInterface : superInterfaces) {
            Class_ superInterface_ = this.importClassInternal(usedSuperInterface);
            class_.addSuperInterface(superInterface_);
        }
        for (int i = 0; i < superGenericInterfaces.length; ++i) {
            CompiledClassImporter.importTypeParameters(superGenericInterfaces[i], superInterfaces[i], class_.typeParameters);
        }
        for (Class<?> innerClass : clazz.getDeclaredClasses()) {
            try {
                Class_ innerClass_ = this.importClassInternal(innerClass);
                if (innerClass_ == null) continue;
                class_.addRelation(RelationType.InnerClass, innerClass_);
            }
            catch (Throwable t) {
                this.processThrowable(Level.WARNING, t, innerClass.getName());
            }
        }
        this.importMethods(clazz, declaredFields, declaredMethods, class_);
        this.importFields(clazz, declaredFields, class_);
        this.importConstructors(clazz, clazz.getDeclaredConstructors(), class_);
        this.importAnnotations(clazz.getDeclaredAnnotations(), class_.annotations);
        class_.membersFinished();
        return class_;
    }

    private void importFields(Class clazz, Collection<Field> fields, Class_ class_) {
        Set<ElementModifier> constantDesignator = constantModifiers;
        for (Field field : fields) {
            ParameterizableElement attribute;
            String name = field.getName();
            Collection<ElementModifier> elementModifiers = this.decodeModifiers(field.getModifiers(), field);
            if (elementModifiers.containsAll(constantDesignator)) {
                elementModifiers.removeAll(constantDesignator);
                attribute = new ParameterizableElement(field.toString(), name, field.getType(), field.getGenericType(), elementModifiers, ElementKind.Constants, CompiledClassImporter.getVisibility(elementModifiers));
            } else {
                attribute = new ParameterizableElement(field.toString(), name, field.getType(), field.getGenericType(), elementModifiers, ElementKind.Fields, CompiledClassImporter.getVisibility(elementModifiers));
            }
            class_.addMember(attribute);
            this.importAnnotations(field.getDeclaredAnnotations(), attribute.annotations);
            CompiledClassImporter.importTypeParameters(field.getGenericType(), field.getType(), attribute.typeParameters);
        }
    }

    private void importMethods(Class clazz, Collection<Field> fields, Collection<Method> methods, Class_ class_) {
        HashSet<Method> methodsToIgnore = new HashSet<Method>();
        for (Method method : methods) {
            boolean setterFound;
            String name = method.getName();
            Collection<ElementModifier> elementModifiers = this.decodeModifiers(method.getModifiers(), method);
            LinkedHashSet<Annotation_> annotations = new LinkedHashSet<Annotation_>();
            this.importAnnotations(method.getDeclaredAnnotations(), annotations);
            Matcher accessorMatcher = getterPattern.matcher(name);
            boolean getterFound = accessorMatcher.matches() && method.getParameterTypes().length == 0 && !elementModifiers.contains((Object)ElementModifier.Static);
            if (!getterFound) continue;
            EnumSet<ElementModifier> getterVisibility = EnumSet.copyOf(ElementModifier.visibilityModifiers);
            getterVisibility.retainAll(elementModifiers);
            String propertyName = accessorMatcher.group(2);
            try {
                Method setter = clazz.getDeclaredMethod("set" + propertyName, method.getReturnType());
                Collection<ElementModifier> setterModifiers = this.decodeModifiers(setter.getModifiers(), setter);
                EnumSet<ElementModifier> setterVisibility = EnumSet.copyOf(ElementModifier.visibilityModifiers);
                setterVisibility.retainAll(setterModifiers);
                boolean bl = setterFound = !setterModifiers.contains((Object)ElementModifier.Static) && setterVisibility.equals(getterVisibility);
                if (setterFound) {
                    elementModifiers.addAll(setterModifiers);
                    this.importAnnotations(setter.getDeclaredAnnotations(), annotations);
                    methodsToIgnore.add(setter);
                }
            }
            catch (NoSuchMethodException e) {
                setterFound = false;
            }
            if (!setterFound) {
                elementModifiers.add(ElementModifier.ReadOnly);
            }
            String attributeName = Introspector.decapitalize(propertyName);
            try {
                Field attribute = clazz.getDeclaredField(attributeName);
                if (attribute.getType().equals(method.getReturnType())) {
                    elementModifiers.addAll(this.decodeModifiers(attribute.getModifiers(), attribute));
                    this.importAnnotations(attribute.getDeclaredAnnotations(), annotations);
                    fields.remove(attribute);
                }
            }
            catch (NoSuchFieldException | SecurityException attribute) {
                // empty catch block
            }
            elementModifiers.removeAll(ElementModifier.visibilityModifiers);
            elementModifiers.addAll(getterVisibility);
            ParameterizableElement property = new ParameterizableElement(method.toGenericString(), attributeName, method.getReturnType(), method.getGenericReturnType(), elementModifiers, ElementKind.Properties, CompiledClassImporter.getVisibility(elementModifiers));
            property.annotations.addAll(annotations);
            class_.addMember(property);
            methodsToIgnore.add(method);
            CompiledClassImporter.importTypeParameters(method.getGenericReturnType(), method.getReturnType(), property.typeParameters);
        }
        for (Method method : methods) {
            if (methodsToIgnore.contains(method)) continue;
            this.importOperation(method.toGenericString(), method.getName(), method.getReturnType(), method.getGenericReturnType(), this.decodeModifiers(method.getModifiers(), method), method, ElementKind.Methods, class_);
        }
        methodsToIgnore.clear();
    }

    private void importConstructors(Class clazz, Constructor[] declaredConstructors, Class_ class_) {
        for (Constructor method : declaredConstructors) {
            this.importOperation(method.toGenericString(), clazz.getSimpleName(), Void.TYPE, Void.TYPE, this.decodeModifiers(method.getModifiers(), method), method, ElementKind.Constructors, class_);
        }
    }

    private void importOperation(String id, String methodName, Class methodType, Type methodGenericType, Collection<ElementModifier> modifiers, Executable method, ElementKind elementKind, Class_ class_) {
        Parameter[] methodParams = method.getParameters();
        ArrayList<ParameterizableElement> parameters = new ArrayList<ParameterizableElement>(methodParams.length);
        for (Parameter methodParam : methodParams) {
            ParameterizableElement parameter = new ParameterizableElement(methodParam.getName(), methodParam.getName(), methodParam.getType(), methodParam.getParameterizedType(), this.decodeModifiers(methodParam.getModifiers(), methodParam), ElementKind.Parameters, ElementVisibility.Local);
            this.importAnnotations(methodParam.getAnnotations(), parameter.annotations);
            parameters.add(parameter);
            CompiledClassImporter.importTypeParameters(methodParam.getParameterizedType(), methodParam.getType(), parameter.typeParameters);
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        ArrayList<ParameterizableElement> throwables = new ArrayList<ParameterizableElement>(exceptionTypes.length);
        for (int i = 0; i < exceptionTypes.length; ++i) {
            throwables.add(new ParameterizableElement(String.format("[%d] %s", i + 1, exceptionTypes[i].getCanonicalName()), "e" + (i + 1), exceptionTypes[i], exceptionTypes[i], Collections.EMPTY_LIST, ElementKind.Throws, ElementVisibility.Local));
        }
        Operation operation = new Operation(id, methodName, methodType, methodGenericType, modifiers, elementKind, CompiledClassImporter.getVisibility(modifiers), parameters.isEmpty() ? Collections.EMPTY_LIST : parameters, throwables.isEmpty() ? Collections.EMPTY_LIST : throwables);
        this.importAnnotations(method.getDeclaredAnnotations(), operation.annotations);
        class_.addMember(operation);
        CompiledClassImporter.importTypeParameters(methodGenericType, methodType, operation.typeParameters);
    }

    private void importAnnotations(Annotation[] declaredAnnotations, Collection<Annotation_> annotations) {
        for (Annotation declaredAnnotation : declaredAnnotations) {
            Class<? extends Annotation> type = declaredAnnotation.annotationType();
            Annotation_ annotation = new Annotation_(declaredAnnotation.toString(), "@" + type.getSimpleName(), type);
            annotations.add(annotation);
        }
    }

    private static void importTypeParameters(Type declaredType, Class classExclusion, Collection<String> typeParameters) {
        if (declaredType instanceof Type && !(declaredType instanceof Class)) {
            CompiledClassImporter.importTypeParameters(declaredType, classExclusion, typeParameters, Collections.EMPTY_LIST);
        }
    }

    private static void importTypeParameters(Type declaredType, Class classExclusion, Collection<String> typeParameters, Collection<Type> history) {
        block13: {
            ArrayList<Type> lHistory;
            block12: {
                if (history.contains(declaredType)) {
                    return;
                }
                lHistory = new ArrayList<Type>(history);
                lHistory.add(declaredType);
                if (!(declaredType instanceof Class)) break block12;
                Class<?> type = Utils.getClassType((Class)declaredType);
                if (type == null) {
                    return;
                }
                String typeName = type.getName();
                if (classExclusion.getName().equals(typeName) || typeParameters.contains(typeName)) break block13;
                typeParameters.add(typeName);
                break block13;
            }
            if (declaredType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)declaredType;
                CompiledClassImporter.importTypeParameters(parameterizedType.getRawType(), classExclusion, typeParameters, lHistory);
                for (Type actualTypeArg : parameterizedType.getActualTypeArguments()) {
                    CompiledClassImporter.importTypeParameters(actualTypeArg, classExclusion, typeParameters, lHistory);
                }
            } else if (declaredType instanceof WildcardType) {
                Type[] bounds;
                WildcardType wildcardType = (WildcardType)declaredType;
                boolean lowerBoundsExist = wildcardType.getLowerBounds().length > 0;
                for (Type actualTypeArg : bounds = lowerBoundsExist ? wildcardType.getLowerBounds() : wildcardType.getUpperBounds()) {
                    CompiledClassImporter.importTypeParameters(actualTypeArg, classExclusion, typeParameters, lHistory);
                }
            } else if (declaredType instanceof GenericArrayType) {
                GenericArrayType genericArrayType = (GenericArrayType)declaredType;
                CompiledClassImporter.importTypeParameters(genericArrayType.getGenericComponentType(), classExclusion, typeParameters, lHistory);
            } else if (declaredType instanceof TypeVariable) {
                Type[] bounds;
                TypeVariable typeVariable = (TypeVariable)declaredType;
                for (Type actualTypeArg : bounds = typeVariable.getBounds()) {
                    CompiledClassImporter.importTypeParameters(actualTypeArg, classExclusion, typeParameters, lHistory);
                }
            }
        }
    }

    private static ElementKind getKind(Collection<ElementModifier> modifiers, Class clazz) {
        if (modifiers.contains((Object)ElementModifier.Annotation)) {
            return ElementKind.AnnotationType;
        }
        if (modifiers.contains((Object)ElementModifier.Interface)) {
            return ElementKind.Interface;
        }
        if (modifiers.contains((Object)ElementModifier.Enum)) {
            return ElementKind.Enum;
        }
        while (clazz.getSuperclass() != null && !Object.class.getName().equals(clazz.getSuperclass().getName())) {
            clazz = clazz.getSuperclass();
        }
        if (Throwable.class.getName().equals(clazz.getName())) {
            return ElementKind.Throwable;
        }
        return ElementKind.Class;
    }

    private static ElementVisibility getVisibility(Collection<ElementModifier> modifiers) {
        if (modifiers.contains((Object)ElementModifier.Public)) {
            return ElementVisibility.Public;
        }
        if (modifiers.contains((Object)ElementModifier.Protected)) {
            return ElementVisibility.Protected;
        }
        if (modifiers.contains((Object)ElementModifier.Private)) {
            return ElementVisibility.Private;
        }
        return ElementVisibility.Package;
    }

    private Collection<ElementModifier> decodeModifiers(Integer modifiers, Object element) {
        EnumSet<ElementModifier> elementModifiers = EnumSet.noneOf(ElementModifier.class);
        for (Map.Entry<ElementModifier, Method> e : this.generalModifierProcessors.entrySet()) {
            try {
                if (!Boolean.TRUE.equals(e.getValue().invoke(null, modifiers))) continue;
                elementModifiers.add(e.getKey());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                logger.log(Level.WARNING, "Unexpected exception during checking modifiers", ex);
            }
        }
        for (Map.Entry<ElementModifier, Method> e : this.elementModifierProcessors.get(element.getClass().getName()).entrySet()) {
            try {
                if (!Boolean.TRUE.equals(e.getValue().invoke(element, new Object[0]))) continue;
                elementModifiers.add(e.getKey());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                logger.log(Level.WARNING, "Unexpected exception during checking modifiers", ex);
            }
        }
        return elementModifiers;
    }

    private void addRelations(Class_ class_, Collection<? extends ParameterizableElement> elements, RelationType relType) {
        for (ParameterizableElement parameterizableElement : elements) {
            this.addRelation(class_, parameterizableElement.originalTypeName, relType);
            for (String typeName : parameterizableElement.typeParameters) {
                this.addRelation(class_, typeName, relType);
            }
            for (Annotation_ annotation_ : parameterizableElement.annotations) {
                this.addRelation(class_, annotation_.originalTypeName, RelationType.DependencyAnnotation);
            }
            if (parameterizableElement instanceof Operation) {
                Operation operation = (Operation)parameterizableElement;
                this.addRelations(class_, operation.parameters, RelationType.Dependency);
                this.addRelations(class_, operation.throwables, RelationType.DependencyThrows);
            }
            parameterizableElement.typeParameters.clear();
            parameterizableElement.typeParameters = Collections.EMPTY_LIST;
            if (!parameterizableElement.annotations.isEmpty()) continue;
            parameterizableElement.annotations = Collections.EMPTY_LIST;
        }
    }

    private void addRelation(Class_ class_, String targetType, RelationType relType) {
        try {
            Class_ targetClass = this.importClassInternal(targetType);
            if (targetClass != null && targetClass != class_) {
                class_.addRelation(relType, targetClass);
            }
        }
        catch (Throwable t) {
            this.processThrowable(Level.WARNING, t, "Problem during retrieving relation: {0} -> {1}", class_.originalTypeName, targetType);
        }
    }

    private void processThrowable(Level level, Throwable throwable, String className) {
        this.importedClasses.remove(className);
        this.processThrowable(level, throwable, "Problem during importing class: {0}", className, null);
    }

    private void processThrowable(Level level, Throwable throwable, String msg, String mainClass, String targetClass) {
        if (targetClass != null) {
            this.importedClasses.remove(targetClass);
        }
        logger.log(level, msg + "\n\t" + Utils.rootCauseAsString(throwable), new String[]{mainClass, targetClass});
        logger.throwing("", "", throwable);
    }

    private static Type[] getCorrectedGenericTypes(Type[] genericTypes, Class[] regularTypes, String elementId, boolean reportIncorrectGenerics) {
        Type[] results = genericTypes;
        if (regularTypes.length != genericTypes.length) {
            results = regularTypes;
            if (reportIncorrectGenerics && logger.isLoggable(Level.FINER)) {
                logger.finer(String.format("Wrong number of generic types (%d instead of %d) on element '%s'", genericTypes.length, regularTypes.length, elementId));
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("regular types:");
                    for (Class c : regularTypes) {
                        logger.finest(c.toString());
                    }
                    logger.finest("generic types:");
                    for (Type t : genericTypes) {
                        logger.finest(t.toString());
                    }
                }
            }
        }
        return results;
    }

    public Collection<Class_> getImportedClasses() {
        return this.importedClasses.values();
    }

    public Class_ getImportedClassesRoot() {
        return this.importedClasses.get(Object.class.getName());
    }

    public Class_ getImportedSimpleClass() {
        Class_ smallClass = this.importedClasses.get(AccessibleObject.class.getName());
        return smallClass != null ? smallClass : this.getImportedClassesRoot();
    }

    public int getNotImportedClassesCount() {
        return this.notImportedClassNames.size();
    }

    public URLClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(URLClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setImportProgressListener(ImportProgressListener importProgressListener) {
        this.importProgressListener = importProgressListener;
    }

    static {
        ElementKind[] memberKinds = new ElementKind[]{ElementKind.Constants, ElementKind.Fields, ElementKind.Properties, ElementKind.Constructors, ElementKind.Methods};
        RelationType[] relationTypes = new RelationType[]{RelationType.Association, RelationType.Association, RelationType.Association, RelationType.Dependency, RelationType.Dependency};
        for (int i = 0; i < memberKinds.length; ++i) {
            memberKindRelations.put(memberKinds[i], relationTypes[i]);
        }
        getterPattern = Pattern.compile("(get|is)(\\p{Upper}\\w*)");
    }
}

